//============================================================
// Program:		WindowFrame
// Description:	Class for simplifying the window setup process
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		4/20/01
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _WINDOW_FRAME_
#define _WINDOW_FRAME_

#pragma warning(disable:4995)

#include <windows.h>
#include <windowsx.h>
#include <math.h>
#include <iostream.h> 
#include <mmsystem.h>

LRESULT WINAPI MsgProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

class WindowFrame
{
public:
	
	WindowFrame(char *program_name = "WindowFrame", bool debug_detail = 0);
	~WindowFrame();
	void BeginWindow(HINSTANCE hInst, char *name = "WindowFrame Window", WNDPROC msg_proc = MsgProc, 
					 int width = -1, int height = -1, int bk_color = DKGRAY_BRUSH);
	void DestroyWindow(void);
	void StartMainLoop(void (*loop_func)(void));
	void StopMainLoop(void);

	char		   *ProgramName;
	char			LocalPath[MAX_PATH + 256];
	HWND			WinHandle;
	WNDCLASSEX		WinClass;
	HINSTANCE		WinInstance;
	char		   *WinName;
	int				Width;
	int				Height;

	int				IsGamePaused;
	int				IsGameLocked;

protected:

	bool			run_main_loop;
	bool			state_toggle;

	__int64			program_start_time;
	__int64			start_time;
	__int64			frame_count;
	__int64			last_time;
	__int64			counter_frequency;
	float			time_diff;
	float			FPS;
};

#endif