//============================================================
// Program:		CGFSoundSystem
// Description:	DirectSound Wrapper
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _CGF_SOUND_SYSTEM_
#define _CGF_SOUND_SYSTEM_

#include <dmusici.h>

struct SOUND_NODE
{
	IDirectMusicSegment8* Segment; 
};

class GameFrame;
class CGFSoundSystem
{
public:
	CGFSoundSystem();
	~CGFSoundSystem();

	void BeginDirectSound(GameFrame *gfparent, char *search_path, int num_nodes);
	void DestroyDirectSound(void);

	int AddSound(char *file);
	void PlaySound(int index, DWORD delay = 0, DWORD flags = DMUS_SEGF_DEFAULT | DMUS_SEGF_SECONDARY);
	void StopSound(int index, DWORD msec = 0);
	void SetRepeats(int index, DWORD num = DMUS_SEG_REPEAT_INFINITE);
	int IsPlaying(int index);

	_inline const	int&	GetLibNumNodes(void)	{ return NumNodes; }
	_inline const	int&	GetLibNumUsed(void)		{ return NumUsed; }

private:

	GameFrame					*GFParent;

	IDirectMusicPerformance8	*Performance;
	IDirectMusicLoader8			*Loader;
	
	SOUND_NODE					*Library;
	int							NumNodes;
	int							NumUsed;
};

#endif


