//============================================================
// Program:		CGFSolarSystem
// Description:	Solar System Class
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _CGF_SOLARSYSTEM_
#define _CGF_SOLARSYSTEM_

#pragma warning(disable:4995)
#include <d3dx8.h>

const double Gc = 3.45354277729E-21;	//Units: (N*Ud)/(Kg^2)

class CGFCamera;
class CGFSmartLoader;
class GameFrame;

struct DATA_FILES
{
	char Body[MAX_PATH];
	char Atmosphere[MAX_PATH];
};

struct ORIENTATION_INFO
{
	float Yaw, Pitch, Roll;
	float YawVec, PitchVec, RollVec; 
};

struct BACKGROUND
{
	int					BackgroundObjectIndex;
	ORIENTATION_INFO	BackgroundData;
	void (*Modifier)(BACKGROUND *background, GameFrame *gfparent, CGFCamera *camera);
};

struct PLANET
{
	int					IsActive;
	float				Life;

	float				Mass;
	float				PlanetRadius;
	float				AtmosphereRadius;
	float				X, Y, Z;
	float				XVec, YVec, ZVec;

	int					MaterialLibIndex;

	int					PlanetObjectIndex;
	ORIENTATION_INFO	PlanetData;

	int					AtmosphereObjectIndex;
	ORIENTATION_INFO	AtmosphereData;

	void (*Modifier)(PLANET *planet, GameFrame *gfparent, CGFCamera *camera);
	DWORD				Flags;
	float				Extra1, Extra2, Extra3;
};

struct SUN
{
	int					IsActive;

	float				Mass;
	float				SunRadius;
	float				X, Y, Z;
	float				XVec, YVec, ZVec;

	int					SunObjectIndex;
	ORIENTATION_INFO	SunData;

	int					AtmosphereObjectIndex;
	ORIENTATION_INFO	AtmosphereData;

	void (*Modifier)(SUN *sun, GameFrame *gfparent, CGFCamera *camera);
	DWORD				Flags;
	float				Extra1, Extra2, Extra3;

    D3DLIGHT8			Light;
};

class CGFSolarSystem
{
	friend CGFCamera;
public:
	CGFSolarSystem();
	~CGFSolarSystem();

	void Initialize(GameFrame *gfparent, CGFCamera *camera);
	void SetBackgroundUniverse(BACKGROUND *background);
	int  LoadSolarSystem(char *file);
	void ScaleSolarSystem(float factor);
	int  AddPlanet(PLANET *planet);
	int  AddSun(SUN *sun);
	void EnableGravity(int flag)			{ IsGravityActive = flag; }
	void EnableLighting(int flag)			{ IsLightingActive = flag; }
	void Destroy(void);

	void Update(void);
	void Render(D3DXMATRIX *modifier = NULL);

	int				GetNumActivePlanets(void)	{ return NumPlanetsUsed; }
	int				GetNumActiveSuns(void)		{ return NumSunsUsed; }
	PLANET&			GetPlanet(int index)		{ return Planets[index]; }
	SUN&			GetSun(int index)			{ return Suns[index]; }

private:

	GameFrame	*GFParent;
	CGFCamera	*Camera;
	
	int			IsGravityActive;
	int			IsLightingActive;

	int			IsBackgroundActive;
	BACKGROUND	Background;

	int			NumPlanets;
	int			NumPlanetsUsed;
	PLANET		*Planets;

	int			NumSuns;
	int			NumSunsUsed;
	SUN			*Suns;
};

#endif
