//============================================================
// Program:		CGFObjectLibrary
// Description:	Class for storing objects
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#include "GameFrameObjectLibrary.h"
#include "GameFrame.h"

CGFObjectLibrary::CGFObjectLibrary() 
{ 
	GFParent = NULL; 
	Library = NULL;
	NumNodes = 0;
	NumUsed = 0;
};

CGFObjectLibrary::~CGFObjectLibrary() 
{ 
	Destroy(); 
}

int CGFObjectLibrary::Initialize(GameFrame *gfparent, int num_nodes)
{
	GFParent = gfparent; 

	if(num_nodes > 0)
	{
		if(Library != NULL) Destroy();

		Library = new OBJNODE[num_nodes];
		NumNodes = num_nodes;
		NumUsed = 0;
		
		for(int i=0; i<NumNodes; i++)
		{
			Library[i].VertexLibraryIndex = -1;
			Library[i].StartVertex = 0;
			Library[i].PrimitiveCount = 0;
			Library[i].PrimitiveType = D3DPT_POINTLIST;
			Library[i].TextureLibraryIndex = -1;
			Library[i].MaterialLibraryIndex = -1;
			Library[i].Radius = 0;
			Library[i].Center = D3DXVECTOR3(0, 0, 0);
			Library[i].BoxMin = D3DXVECTOR3(0, 0, 0);
			Library[i].BoxMax = D3DXVECTOR3(0, 0, 0);
		}

		if(Library != NULL) return 1;
	}
	
	return 0;
}

void CGFObjectLibrary::Destroy(void)
{
	if(Library != NULL)
	{
		delete[] Library;
		Library = NULL;
	}

	NumNodes = 0;
	NumUsed = 0;

	GFParent = NULL;
}

int CGFObjectLibrary::AddObject(OBJNODE *object)
{
	int result = -1;
	if((NumNodes <= 0) || (Library == NULL) || (GFParent == NULL) || (object == NULL)) return -1;

	if(NumUsed >= NumNodes)
	{
		int i = 0;
		OBJNODE *tmp = NULL;
		tmp = new OBJNODE[NumNodes * 2];

		if(tmp == NULL) return -1;

		for(i=0; i<NumNodes; i++)
		{
			tmp[i].VertexLibraryIndex = Library[i].VertexLibraryIndex;
			tmp[i].StartVertex = Library[i].StartVertex;
			tmp[i].PrimitiveCount = Library[i].PrimitiveCount;
			tmp[i].PrimitiveType = Library[i].PrimitiveType;
			tmp[i].TextureLibraryIndex = Library[i].TextureLibraryIndex;
			tmp[i].MaterialLibraryIndex = Library[i].MaterialLibraryIndex;
			tmp[i].Radius = Library[i].Radius;
			tmp[i].Center = Library[i].Center;
			tmp[i].BoxMin = Library[i].BoxMin;
			tmp[i].BoxMax = Library[i].BoxMax;
			memcpy((tmp[i].ObjectName), (Library[i].ObjectName), 256);
		}

		for(i=NumNodes; i<(NumNodes * 2); i++)
		{
			tmp[i].VertexLibraryIndex = -1;
			tmp[i].StartVertex = 0;
			tmp[i].PrimitiveCount = 0;
			tmp[i].PrimitiveType = D3DPT_POINTLIST;
			tmp[i].TextureLibraryIndex = -1;
			tmp[i].MaterialLibraryIndex = -1;
			tmp[i].Radius = 0;
			tmp[i].Center = D3DXVECTOR3(0, 0, 0);
			tmp[i].BoxMin = D3DXVECTOR3(0, 0, 0);
			tmp[i].BoxMax = D3DXVECTOR3(0, 0, 0);
			memset(tmp[i].ObjectName, NULL, 256);
		}

		delete[] Library;
		Library = tmp;
		tmp = NULL;
		NumNodes *= 2;
	}

	Library[NumUsed].VertexLibraryIndex = object->VertexLibraryIndex;
	Library[NumUsed].StartVertex = object->StartVertex;
	Library[NumUsed].PrimitiveCount = object->PrimitiveCount;
	Library[NumUsed].PrimitiveType = object->PrimitiveType;
	Library[NumUsed].TextureLibraryIndex = object->TextureLibraryIndex;
	Library[NumUsed].MaterialLibraryIndex = object->MaterialLibraryIndex;
	Library[NumUsed].Radius = object->Radius;
	Library[NumUsed].Center = object->Center;
	Library[NumUsed].BoxMin = object->BoxMin;
	Library[NumUsed].BoxMax = object->BoxMax;
	memcpy((Library[NumUsed].ObjectName), (object->ObjectName), 256);

	result = NumUsed;
	NumUsed++;

	return result;
}

int CGFObjectLibrary::FindObject(char *name)
{
	for(int i=0; i<NumUsed; i++)
	{
		if(strcmp(name, Library[i].ObjectName) == 0)
		{
			return i;
		}
	}
	return -1;
}

