//============================================================
// Program:		CGFFontLibrary
// Description:	Simple font wrapper
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#include "GameFrameFontLibrary.h"
#include "GameFrame.h"

CGFFontLibrary::CGFFontLibrary() 
{ 
	GFParent = NULL; 
	Library = NULL;
	NumNodes = 0;
	NumUsed = 0;
	CurrentFont = 0;
	StasisFlag = 0;
};

CGFFontLibrary::~CGFFontLibrary() 
{ 
	Destroy(); 
}

int CGFFontLibrary::Initialize(GameFrame *gfparent, int num_nodes)
{
	GFParent = gfparent; 

	if(num_nodes > 0)
	{
		if(Library != NULL) Destroy();

		Library = new FONT_NODE[num_nodes];
		NumNodes = num_nodes;
		NumUsed = 0;
		CurrentFont = 0;
		
		for(int i=0; i<NumNodes; i++)
		{
			Library[i].Font = NULL;
			Library[i].Width = 0;
			Library[i].Height = 0;
		}

		if(Library != NULL) return 1;
	}
	
	return 0;
}

void CGFFontLibrary::Destroy(void)
{
	if(Library != NULL)
	{
		for(int i=0; i<NumNodes; i++)
		{
			if(Library[i].Font != NULL)
			{
				Library[i].Font->Release();
				Library[i].Font = NULL;
			}
		}

		delete[] Library;
		Library = NULL;
	}

	StasisFlag = 0;
	NumNodes = 0;
	NumUsed = 0;
	CurrentFont = 0;

	GFParent = NULL;
}

void CGFFontLibrary::OnLostDevice(void)
{
	if(Library != NULL)
	{
		for(int i=0; i<NumUsed; i++)
		{
			if(Library[i].Font != NULL)
			{
				Library[i].Font->OnLostDevice();
			}
		}
	}
}

void CGFFontLibrary::OnResetDevice(void)
{
	if(Library != NULL)
	{
		for(int i=0; i<NumUsed; i++)
		{
			if(Library[i].Font != NULL)
			{
				Library[i].Font->OnResetDevice();
			}
		}
	}
}

int CGFFontLibrary::AddFont(HFONT font, int width, int height)
{
	int result = -1;
	if((NumNodes <= 0) || (Library == NULL) || (GFParent == NULL)) return -1;

	if(NumUsed >= NumNodes)
	{
		int i = 0;
		FONT_NODE *tmp = NULL;
		tmp = new FONT_NODE[NumNodes * 2];

		if(tmp == NULL) return -1;

		for(i=0; i<NumNodes; i++)
		{
			tmp[i].Font = Library[i].Font;
			tmp[i].Width = Library[i].Width;
			tmp[i].Height = Library[i].Height;
		}

		for(i=NumNodes; i<(NumNodes * 2); i++)
		{
			tmp[i].Font = NULL;
			tmp[i].Width = 0;
			tmp[i].Height = 0;
		}

		delete[] Library;
		Library = tmp;
		tmp = NULL;
		NumNodes *= 2;
	}

	if(D3D_OK == D3DXCreateFont(GFParent->D3DDevice, font, &(Library[NumUsed].Font)))
	{
		result = NumUsed;
		Library[NumUsed].Width = width;
		Library[NumUsed].Height = height;
		NumUsed++;
	}

	return result;
}

void CGFFontLibrary::BeginFont(int index)
{
	if(GFParent->IsGamePaused || GFParent->IsGameLocked) return;
	
	StasisFlag = 0;
	if(D3D_OK != GFParent->D3DDevice->TestCooperativeLevel())
	{
		StasisFlag = 1;
		return;
	}

	Library[index].Font->Begin();
	CurrentFont = index;
}

void CGFFontLibrary::DrawText(char *buffer, RECT *text_rect, DWORD color, DWORD flags)
{
	if(GFParent->IsGamePaused || GFParent->IsGameLocked) return;
	if(StasisFlag) return;

	Library[CurrentFont].Font->DrawText(buffer, -1, text_rect, flags, color);
}

void CGFFontLibrary::DrawText(char *buffer, int x, int y, DWORD color)
{
	if(GFParent->IsGamePaused || GFParent->IsGameLocked) return;
	if(StasisFlag) return;

	RECT text_rect;
	text_rect.top = y;
	text_rect.left = x;
	text_rect.bottom = GFParent->Height;
	text_rect.right = GFParent->Width;

	Library[CurrentFont].Font->DrawText(buffer, -1, &text_rect, DT_LEFT, color);
}

void CGFFontLibrary::EndFont(int index)
{
	if(GFParent->IsGamePaused || GFParent->IsGameLocked) return;
	if(StasisFlag) return;

	Library[index].Font->End();
	CurrentFont = 0;
}
