//============================================================
// Program:		DebugHandler
// Description:	Logfile based debugger
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		January 5th, 2001
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================


#ifndef _GFDEBUG_HANDLER_
#define _GFDEBUG_HANDLER_		

#include <stdio.h>
#include <assert.h>
#include <windows.h>

int InitDebugger(char *progname, char *path, HWND hWnd = NULL, bool detailed_mode = 0);
int SetDebuggerHandle(HWND hWnd);
int DebugAction(int result, const char* command, const char* file, int line);
int InsertMessage(const char *message, const char *file, int line);
int CloseDebugger(void);

#define Confirm(exp){		DebugAction(exp, #exp, __FILE__, __LINE__);		}
#define Message(msg){		InsertMessage(msg, __FILE__, __LINE__);			}

#endif