//============================================================
// Program:		DebugHandler
// Description:	Logfile based debugger
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		January 5th, 2001
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#include "GFDebugHandler.h"

HWND __hwnd__ = NULL;
INT  __detailed_mode__ = 0;
BOOL __display_logfile__ = 0;
char __logfile_name__[100];
char __full_logfile_path__[MAX_PATH];

int InitDebugger(char *progname, char *path, HWND hWnd, bool detailed_mode)
{
	FILE *fp = NULL;

	sprintf(__logfile_name__, "%s_DebugLog.html", progname);
	sprintf(__full_logfile_path__, "%s%s_DebugLog.html", path, progname);

	fp = fopen(__full_logfile_path__, "wt");
	
	if(!fp)
	{
		MessageBox(NULL, "Unable to open debug log!", "Debug Message:", MB_OK|MB_ICONEXCLAMATION);
	}
	else
	{
		fprintf(fp, "<html> \n");
		fprintf(fp, "<head> \n");
		fprintf(fp, "<title>%s Debugger File</title> \n", progname);
		fprintf(fp, "</head> \n");
		fprintf(fp, "<body> \n");
		fprintf(fp, "\n");

		fclose(fp);
	}

	__hwnd__ = hWnd;
	__detailed_mode__ = detailed_mode;

	return 0;
}


int SetDebuggerHandle(HWND hWnd)
{
	
	__hwnd__ = hWnd;
	
	return 1;
}


int DebugAction(int result, const char* command, const char* file, int line)
{
	
	FILE *fp = NULL;
	static int count = 0;
	static error_count = 0;

	count++;

	fp = fopen(__full_logfile_path__, "at");
	if(fp != NULL)
	{
		if(result == TRUE)
		{
			if(__detailed_mode__)
			{
				fprintf(fp, "<br> \n");
				fprintf(fp, "<table width=\"100%c\" cellpadding=\"2\" cellspacing=\"0\" border=\"0\"> \n", '%');
				fprintf(fp, "    <tr><td colspan=2 align=center bgcolor=\"3366CF\"><font face=\"Verdana, helvetica, sans-serif\" size=3 color=\"ffffff\"><B>Event %d Succeded</B></font></td></tr> \n", count);
				fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp CODE:   </strong>  <FONT COLOR=\"#00006F\"><small>%s</small></FONT></td></tr> \n", command);
				fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp RESULT: </strong>  <FONT COLOR=\"#00006F\"><small>%d</small></FONT></td></tr> \n", result);
				fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp FILE:   </strong>  <FONT COLOR=\"#00006F\"><small>%s</small></FONT></td></tr> \n", file);
				fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp LINE:   </strong>  <FONT COLOR=\"#00006F\"><small>%d</small></FONT></td></tr> \n", line);
				fprintf(fp, "</table> \n\n");
			}
		}
		else
		{
			fprintf(fp, "<br> \n");
			fprintf(fp, "<table width=\"100%c\" cellpadding=\"2\" cellspacing=\"0\" border=\"0\"> \n", '%');
			fprintf(fp, "    <tr><td colspan=2 align=center bgcolor=\"FF0000\"><font face=\"Verdana, helvetica, sans-serif\" size=3 color=\"ffffff\"><B>Event %d Failed</B></font></td></tr> \n", count);
			fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp CODE:   </strong>  <FONT COLOR=\"#00006F\"><small>%s</small></FONT></td></tr> \n", command);
			fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp RESULT: </strong>  <FONT COLOR=\"#00006F\"><small>%d</small></FONT></td></tr> \n", result);
			fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp FILE:   </strong>  <FONT COLOR=\"#00006F\"><small>%s</small></FONT></td></tr> \n", file);
			fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp LINE:   </strong>  <FONT COLOR=\"#00006F\"><small>%d</small></FONT></td></tr> \n", line);
			fprintf(fp, "</table> \n\n");
		}

		fclose(fp);
	}
	else
	{
		MessageBox(NULL, "Unable to open debug log!", "Debug Message:", MB_OK|MB_ICONEXCLAMATION);
	}

	if(result == FALSE)
	{		
		__display_logfile__ = 1;

		if((error_count < 2) && (__hwnd__ != NULL))
		{
			PostMessage(__hwnd__, WM_QUIT, 0, 0);
		}
		else
		{
			CloseDebugger();
			exit(0);
		}
		
		error_count ++;
	}

	return 1;
}


int InsertMessage(const char *message, const char *file, int line)
{
	FILE *fp = NULL;

	fp = fopen(__full_logfile_path__, "at");
	if(fp != NULL)
	{
		fprintf(fp, "<br> \n");
		fprintf(fp, "<table width=\"100%c\" cellpadding=\"2\" cellspacing=\"0\" border=\"0\"> \n", '%');
		fprintf(fp, "    <tr><td colspan=2 align=center bgcolor=\"006565\"><font face=\"Verdana, helvetica, sans-serif\" size=3 color=\"ffffff\"><B>Inserted Message</B></font></td></tr> \n");
		fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp MESSAGE:   </strong>  <FONT COLOR=\"#00006F\"><small>%s</small></FONT></td></tr> \n", message);
		fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp FILE:   </strong>  <FONT COLOR=\"#00006F\"><small>%s</small></FONT></td></tr> \n", file);
		fprintf(fp, "    <tr><td bgcolor=\"DDDDDD\"><strong>&nbsp &nbsp LINE:   </strong>  <FONT COLOR=\"#00006F\"><small>%d</small></FONT></td></tr> \n", line);
		fprintf(fp, "</table> \n\n");

		fclose(fp);
	}
	else
	{
		MessageBox(NULL, "Unable to open debug log!", "Debug Message:", MB_OK|MB_ICONEXCLAMATION);
	}

	return 1;
}


int CloseDebugger(void)
{
	FILE *fp = NULL;
	
	fp = fopen(__full_logfile_path__, "at");
	
	if(!fp)
	{
		MessageBox(NULL, "Unable to open debug log!", "Debug Message:", MB_OK|MB_ICONEXCLAMATION);
	}
	else
	{
		fprintf(fp, "\n");
		fprintf(fp, "</body> \n");
		fprintf(fp, "</html> \n");

		fclose(fp);
	}
	
	if(__display_logfile__)
	{
		ShellExecute(__hwnd__, "open", __full_logfile_path__, NULL, NULL, SW_SHOWMAXIMIZED);
	}

	return 1;
}

