// WinSleepDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WinSleep.h"
#include "WinSleepDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TIMER_ID	WM_USER + 1
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinSleepDlg dialog

CWinSleepDlg::CWinSleepDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWinSleepDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWinSleepDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWinSleepDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWinSleepDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWinSleepDlg, CDialog)
	//{{AFX_MSG_MAP(CWinSleepDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON1, OnSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinSleepDlg message handlers

BOOL CWinSleepDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CString msg;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	m_OperationBox = (CComboBox *) GetDlgItem(IDC_COMBO1);
	m_SleepTimeBox1 = (CComboBox *) GetDlgItem(IDC_COMBO2);
	m_SleepTimeBox2 = (CDateTimeCtrl *) GetDlgItem(IDC_DATETIMEPICKER1);
	m_Sleep1Check = (CButton *) GetDlgItem(IDC_RADIO1);
	m_Sleep2Check = (CButton *) GetDlgItem(IDC_RADIO2);

	m_OperationBox->AddString("Power off");
	m_OperationBox->AddString("Shut down");
	m_OperationBox->AddString("Restart");
	m_OperationBox->AddString("Log off");
	m_OperationBox->SetCurSel(0);

	m_SleepTimeBox1->AddString("1 minute");
	for(int i=2; i<=720; i++)
	{
		msg.Format("%d minutes", i);
		m_SleepTimeBox1->AddString(msg);
	}
	m_SleepTimeBox1->SetCurSel(9);
	
	CTime mytime(21600);
	m_SleepTimeBox2->SetTime(&mytime);
	m_Sleep1Check->SetCheck(1);
	m_SleepTimeBox2->EnableWindow(0);

	WeAreSet = 0;
	SetTimer(TIMER_ID, 1000, NULL);
	start_time = CTime::GetCurrentTime();


	isNT = 0;

	OSVERSIONINFO OSType;
	OSType.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&OSType);
	if(OSType.dwPlatformId == VER_PLATFORM_WIN32_NT)
	{
		isNT = 1;
	}

	if(isNT)
	{
		OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &TokenHandle);
		LookupPrivilegeValue(NULL, SE_SHUTDOWN_NAME, &tkp.Privileges[0].Luid); 
		tkp.PrivilegeCount = 1; 
		tkp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED; 
		AdjustTokenPrivileges(TokenHandle, FALSE, &tkp, 0, (PTOKEN_PRIVILEGES) NULL, 0);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWinSleepDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWinSleepDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CWinSleepDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWinSleepDlg::OnRadio1() 
{
	m_SleepTimeBox1->EnableWindow(1);
	m_SleepTimeBox2->EnableWindow(0);		
}

void CWinSleepDlg::OnRadio2() 
{
	m_SleepTimeBox1->EnableWindow(0);
	m_SleepTimeBox2->EnableWindow(1);		
}

afx_msg void CWinSleepDlg::OnTimer(UINT ID)
{
	CString msg;
	CTimeSpan mytimer;
	long time_diff = 0;

	if(WeAreSet)
	{
		mytimer = finish_time - CTime::GetCurrentTime() + CTimeSpan(1, 0, 0, 0);

		msg.Format("WinSleep   %d:%d:%d", mytimer.GetHours(), mytimer.GetMinutes(), mytimer.GetSeconds());
		SetWindowText(msg);
	
		time_diff = (mytimer.GetHours() * 60 * 60) +
					(mytimer.GetMinutes() * 60) +
					(mytimer.GetSeconds());
		if((time_diff < 1) || (time_diff > 86396))
		{
			WeAreSet = 0;
			RunOperation(OpState);
		}
	}
}

afx_msg void CWinSleepDlg::OnDestroy()
{
	KillTimer(TIMER_ID);

	if(isNT)
	{
		tkp.Privileges[0].Attributes = 0; 
		AdjustTokenPrivileges(TokenHandle, FALSE, &tkp, 0, (PTOKEN_PRIVILEGES) NULL, 0); 
		CloseHandle(TokenHandle);
	}
}

void CWinSleepDlg::OnSet() 
{
	if(m_Sleep1Check->GetCheck())
	{
		finish_time = CTime::GetCurrentTime() + (m_SleepTimeBox1->GetCurSel() + 1) * 60;
	}
	
	if(m_Sleep2Check->GetCheck())
	{
		CTime tmp_time;
		CTime curr_time = CTime::GetCurrentTime();

		m_SleepTimeBox2->GetTime(tmp_time);
		finish_time = CTime(curr_time.GetYear(), curr_time.GetMonth(), curr_time.GetDay(), 
							tmp_time.GetHour(), tmp_time.GetMinute(), tmp_time.GetSecond());
	}

	OpState = m_OperationBox->GetCurSel();

	WeAreSet = 1;
}

void CWinSleepDlg::RunOperation(int num)
{
	switch(num)
	{
		case 0:
		{
			ExitWindowsEx(EWX_POWEROFF, 0);
		} break;

		case 1:
		{
			ExitWindowsEx(EWX_SHUTDOWN, 0);
		} break;

		case 2:
		{
			ExitWindowsEx(EWX_REBOOT, 0);
		} break;

		case 3:
		{
			ExitWindowsEx(EWX_LOGOFF, 0);
		} break;
	}
}



BOOL SetPrivilege(HANDLE hToken, LPCTSTR lpszPrivilege, BOOL bEnablePrivilege) 
{
	TOKEN_PRIVILEGES tp;
	LUID luid;
	char msg[100];

	if ( !LookupPrivilegeValue(NULL, lpszPrivilege, &luid ) ) 
	{      
		sprintf(msg, "LookupPrivilegeValue error: %u\n", GetLastError() ); 
		MessageBox(NULL, msg, "Error", MB_OK);
		return FALSE; 
	}

	tp.PrivilegeCount = 1;
	tp.Privileges[0].Luid = luid;
	if (bEnablePrivilege)
	{
		tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
	}
	else
	{
		tp.Privileges[0].Attributes = 0;
	}

	AdjustTokenPrivileges(hToken, FALSE, &tp, sizeof(TOKEN_PRIVILEGES), (PTOKEN_PRIVILEGES) NULL, (PDWORD) NULL); 

	if (GetLastError() != ERROR_SUCCESS) 
	{ 
		sprintf(msg, "AdjustTokenPrivileges failed: %u\n", GetLastError() ); 
		MessageBox(NULL, msg, "Error", MB_OK);
		return FALSE; 
	} 

	return TRUE;
}

