
/////////////////////////////////////////////////////////////////////
#include "DXEngine.h"
#include "MapGen.h"
/////////////////////////////////////////////////////////////////////

#define SCREEN_WIDTH 1024	
#define SCREEN_HEIGHT 768
#define BPP 8

#define MAX_X SCREEN_WIDTH
#define MAX_Y SCREEN_HEIGHT
#define MID_X (SCREEN_WIDTH/2)
#define MID_Y (SCREEN_HEIGHT/2)

/////////////////////////////////////////////////////////////////////
#define KEY_DOWN(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 1 : 0)
#define KEY_UP(vk_code)   ((GetAsyncKeyState(vk_code) & 0x8000) ? 0 : 1)
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
int Game_Init();
int Game_Main();
int Game_Shutdown();
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
BOOL GameRunning=1; 
char buffer[80];
int perspective_flag = 1;
int poly_mode = 1;
int pal_mode = 0;
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
DXEngine dxengine;
MapGen map;
/////////////////////////////////////////////////////////////////////


int WINAPI WinMain(HINSTANCE hinstance, HINSTANCE hprevinstance, LPSTR lpcmdline, int ncmdshow)
{		
	dxengine.WinInit(hinstance, "DDBackdrop", "DirectX1");
	dxengine.DDInit(SCREEN_WIDTH, SCREEN_HEIGHT, BPP);
	
	RECT ClipList = {0,0,SCREEN_WIDTH,SCREEN_HEIGHT};
	dxengine.DDAttachClipper(&ClipList, 1);	

	dxengine.DDAttachPalette(NULL);
	
	MSG	msg;		
	Game_Init();

	while(GameRunning)
	{
		if(PeekMessage(&msg,NULL,0,0,PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0)) return msg.wParam;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			if(dxengine.IsActive()) Game_Main();
		}
	}
	
	Game_Shutdown();
	return(msg.wParam);
}


int Game_Init()
{
	srand(GetTickCount());
	map.MakeHeightMap(6, 0, 32);
	map.TesselateMap();
	map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
	return 1;
}


int FrameRate = 0;
int FrameCount = 0;
int FrameCount0 = 0;
DWORD FrameTime = 0;
DWORD FrameTime0 = 0;

int Game_Main()
{
	static int i = 6;
	
	
	if(KEY_DOWN(VK_ESCAPE))
	{
		GameRunning = 0;
	}

	if(KEY_DOWN(VK_LEFT))
	{
		map.RotateMap(0,-5,0);
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
	}

	if(KEY_DOWN(VK_RIGHT))
	{
		map.RotateMap(0,5,0);
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
	}

	if(KEY_DOWN(VK_UP))
	{
		map.RotateMap(5,0,0);
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
	}
	
	if(KEY_DOWN(VK_DOWN))
	{
		map.RotateMap(-5,0,0);
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
	}
	
	if(KEY_DOWN(219)) //[
	{
		i--;
		if(i < 4) i = 4;
		map.MakeHeightMap(i, 0, 32);
		map.TesselateMap();
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
		while(KEY_DOWN(219));
	}

	if(KEY_DOWN(221)) //]
	{
		i++;
		if(i>10)i=10;
		map.MakeHeightMap(i, 0, 32);
		map.TesselateMap();
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
		while(KEY_DOWN(221));
	}

	if(KEY_DOWN(VK_SPACE))
	{
		map.DistortMap();
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
	}

	if(KEY_DOWN(189)) //-
	{
		map.ScaleMap((float).9);
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
	}

	if(KEY_DOWN(187)) //+
	{
		map.ScaleMap((float)1.1);
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
	}

	if(KEY_DOWN(VK_RETURN))
	{
		if(perspective_flag == 1)
		{
			perspective_flag = 0;
		}
		else
		{
			perspective_flag = 1;
		}
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
		while(KEY_DOWN(VK_RETURN));
	}

	if(KEY_DOWN(87)) //W 
	{
		if(poly_mode == 1) poly_mode = 0;
		else poly_mode = 1;
		map.ProjectMap(MAX_X, MAX_Y, perspective_flag);
		while(KEY_DOWN(87));
	}

	if(KEY_DOWN(90)) //Z
	{
		if(pal_mode == 1) pal_mode = 0;
		else pal_mode = 1;
		while(KEY_DOWN(90));
	}

	
	dxengine.DDFillBack(0);
	dxengine.DDLockBack();

	if(poly_mode == 1)
	{
		for(long index=0; index<map.num_triangles; index++)
		{
			dxengine.FillTriangle(map.tri_list[index].scr_x1, map.tri_list[index].scr_y1,
								  map.tri_list[index].scr_x2, map.tri_list[index].scr_y2,
								  map.tri_list[index].scr_x3, map.tri_list[index].scr_y3,
								  map.tri_list[index].color);
		}
	}
	else
	{
		for(long index=0; index<map.num_triangles; index++)
		{
			dxengine.Triangle(map.tri_list[index].scr_x1, map.tri_list[index].scr_y1,
								  map.tri_list[index].scr_x2, map.tri_list[index].scr_y2,
								  map.tri_list[index].scr_x3, map.tri_list[index].scr_y3,
								  map.tri_list[index].color);
		}
	}

	if(pal_mode)
	{
		dxengine.DDRotatePalette(1,67);
		dxengine.DDRotatePalette(69,254);
	}

	sprintf(buffer, "proj_dist: %.2f", map.proj_dist);
	dxengine.SetText(MAX_X - 300, 20, buffer, 255);

	sprintf(buffer, "Iterations (decrease/increase) (%d).....[/]", i);
	dxengine.SetText(10, 5, buffer, 255);
	
	sprintf(buffer, "Zoom..........+/-");
	dxengine.SetText(10, 20, buffer, 255);

	sprintf(buffer, "Rotate..........Arrow Keys(left/right/up/down)");
	dxengine.SetText(10, 35, buffer, 255);

	sprintf(buffer, "Fragment Terrain...............Space Bar");
	dxengine.SetText(10, 50, buffer, 255);

	sprintf(buffer, "Toggle Perspective Projection (%s)......Enter Key", (perspective_flag ? "On" : "Off"));
	dxengine.SetText(10, 65, buffer, 255);

	sprintf(buffer, "Toggle Wireframe (%s)......W Key", (poly_mode ? "Solid Fill" : "Wire"));
	dxengine.SetText(10, 80, buffer, 255);

	sprintf(buffer, "Toggle Palette Rotation (%s)...Z Key", (pal_mode ? "On" : "Off"));
	dxengine.SetText(10, 95, buffer, 255);

	sprintf(buffer, "Poly Rendering & Terrain Gen Demo. By: Ben Gottemoller");
	dxengine.SetText(0, 710, buffer, 45);
	
	sprintf(buffer, "Terrain genned using the plasma fractal diamond/square algorithm");
	dxengine.SetText(0, 730, buffer, 45);	

	sprintf(buffer, "Terrain polygon is %u triangles, using %u bytes of ram", 
			map.num_triangles, map.num_triangles * sizeof(TRIANGLE));
	dxengine.SetText(0, 750, buffer, 45);

	sprintf(buffer, "Frame Rate: %d", FrameRate);
	dxengine.SetText(0, 110, buffer, 45);	

	for(int j=0; j<256; j++)
	{
		if(KEY_DOWN(j))
		{
			sprintf(buffer, "Key: %d", j);
			dxengine.SetText(MAX_X - 300, 5, buffer, 255);
		}
	}


	//dxengine.FillTriangle(300, 300, 630, 772, 250, 900, RGB32(0, 250, 150, 0));

	dxengine.DDUnlockBack();
	dxengine.DDFlip();

	FrameCount++;
	FrameTime = timeGetTime();

	if (FrameTime - FrameTime0 > 1000)
	{
		FrameRate = (FrameCount - FrameCount0) * 1000 / (FrameTime - FrameTime0);
		FrameTime0 = FrameTime;
		FrameCount0 = FrameCount;
	}

	return 1;
}


int Game_Shutdown()
{
	ShowCursor(1);
	return 1;
}
