#include <afxwin.h>
#include <mmsystem.h>
#include "resource.h"

#include "NoMoreRect.h"
#include "CommControl.h"

#define IDC_SELECTPORT		1000
#define IDB_ACTIVATE		1005
#define IDB_DEACTIVATE		1010
#define IDB_REFRESHRLSTATS	1011
#define IDC_SELECTRELAY		1015
#define IDL_RELAYSTATUS		1020
#define IDE_COMSTATE		1025
#define IDE_RELAYMESSAGES	1030
#define IDB_REFRESHIPSTATS	1035
#define IDL_INPUTSTATUS		1040
#define IDE_INPUTMESSAGES	1045
#define IDB_AUTOREFRESHIP	1050
#define IDB_AUTOREFRESHRL	1055
#define IDB_ALARMNOTIFYIP	1060
#define IDB_ALARMNOTIFYRL	1060

#define IDT_INPUTS			2000
#define IDT_RELAYS			2005

void CALLBACK InputTimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

class CMainWin:public CFrameWnd
{
public:

	ComControl		Com;
	RelayControl	RelayBoard;
	CButton			m_BGroupBox[10];
	CComboBox		m_CBSelectPort;
	CEdit			m_EComState;
	CButton			m_BActivate;
	CButton			m_BDeactivate;
	CButton			m_BRefreshRlStat;
	CEdit			m_ERelayMessages;
	CListBox		m_LBRelayStatus;
	CButton			m_BRefreshIpStat;
	CListBox		m_LBInputStatus;
	CEdit			m_EInputMessages;

	CButton			m_CAutoRefreshIp;
	CButton			m_CAutoRefreshRl;

	CButton			m_CAlarmNotifyIp;
	CButton			m_CAlarmNotifyRl;

	CEdit			m_ECopyright;

	BOOL PortState;

public:

	CMainWin(LPCSTR ClassName);
	~CMainWin();
	
	afx_msg int OnCreate();
	afx_msg LRESULT OnTrayNotification(WPARAM wp, LPARAM lp);
	afx_msg void OnTimer(UINT nIDEvent);

	afx_msg void OnCBSelectPort();
	afx_msg void OnBActivate();
	afx_msg void OnBDeactivate();
	afx_msg void OnRefreshRlStats();
	afx_msg void OnRefreshIpStats();
	afx_msg void OnCAutoRefreshIp();
	afx_msg void OnCAutoRefreshRl();
	
	DECLARE_MESSAGE_MAP()

private:
	RECT winrect;
};


class CApp:public CWinApp
{
public:
	BOOL InitInstance();
};


///////////////////////////////////////////////////////////////////////////////////////////////////


CMainWin::CMainWin(LPCSTR ClassName)
{
	CNoRect rect(0, 0, 315, 300);
	Create(ClassName, "Remote Control v1.0", WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | 
		   WS_MINIMIZEBOX | WS_VISIBLE, rect.GetDU(), NULL, NULL);
}

CMainWin::~CMainWin()
{
	if(m_CAutoRefreshIp.GetCheck() != 0)
	{
		KillTimer(IDT_INPUTS);
	}

	if(m_CAutoRefreshRl.GetCheck() != 0)
	{
		KillTimer(IDT_RELAYS);
	}
}

afx_msg int CMainWin::OnCreate()
{
	CNoRect rect;
	PortState = 0;

	////Create Main Window////
	CenterWindow(NULL);
	GetClientRect(&winrect);

	////Create static Group Boxes////
	rect.Set(10, 5, 295, 30);
	m_BGroupBox[0].Create("Relay Board Serial Port Connection", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, rect.GetDU(), this, 0xffff);

	rect.Set(5, 45, 300, 120);
	m_BGroupBox[1].Create("Direct Relay Control", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, rect.GetDU(), this, 0xffff);

	rect.Set(5, 170, 300, 90);
	m_BGroupBox[2].Create("Input Monitoring", WS_CHILD | WS_VISIBLE | BS_GROUPBOX, rect.GetDU(), this, 0xffff);


	////Create Buttons////
	rect.Set(15, 60, 55, 15);
	m_BActivate.Create("Activate", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, rect.GetDU(), this, IDB_ACTIVATE);
	
	rect.Set(15, 80, 55, 15);
	m_BDeactivate.Create("Deactivate", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, rect.GetDU(), this, IDB_DEACTIVATE);

	rect.Set(15, 100, 55, 15);
	m_BRefreshRlStat.Create("Refresh", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, rect.GetDU(), this, IDB_REFRESHRLSTATS);

	rect.Set(15, 185, 55, 15);
	m_BRefreshIpStat.Create("Refresh", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, rect.GetDU(), this, IDB_REFRESHIPSTATS);


	////Create Static Edit Box////
	rect.Set(100, 15, 200, 15);
	m_EComState.Create(ES_LEFT | WS_VISIBLE | ES_READONLY | WS_BORDER, rect.GetDU(), this, IDE_COMSTATE);	
	
	rect.Set(10, 145, 290, 15);
	m_ERelayMessages.Create(ES_LEFT | WS_VISIBLE | ES_READONLY | WS_BORDER, rect.GetDU(), this, IDE_RELAYMESSAGES);	

	rect.Set(10, 240, 290, 15);
	m_EInputMessages.Create(ES_LEFT | WS_VISIBLE | ES_READONLY | WS_BORDER, rect.GetDU(), this, IDE_INPUTMESSAGES);	

	rect.Set(5, 265, 300, 15);
	m_ECopyright.Create(ES_CENTER | WS_VISIBLE | ES_READONLY | WS_DLGFRAME, rect.GetDU(), this, 0);
	m_ECopyright.SetWindowText("Copyright (c) 2000 Benjamin P. Gottemoller, All Rights Reserved.");

	////Create Combo Boxes////
	rect.Set(20, 15, 65, 12 + 100);
	m_CBSelectPort.Create(CBS_DROPDOWNLIST | WS_VSCROLL | WS_VISIBLE, rect.GetDU(), this, IDC_SELECTPORT);
	m_CBSelectPort.AddString("Com1");
	m_CBSelectPort.AddString("Com2");
	m_CBSelectPort.AddString("Com3");
	m_CBSelectPort.AddString("Com4");
	m_CBSelectPort.SetCurSel(0);
	

	////Create List Box////
	rect.Set(80, 55, 220, 85);
	m_LBRelayStatus.Create(LBS_USETABSTOPS | WS_VISIBLE | WS_DLGFRAME, rect.GetDU(), this, IDL_RELAYSTATUS);

	rect.Set(80, 180, 220, 55);
	m_LBInputStatus.Create(LBS_USETABSTOPS | WS_VISIBLE | WS_DLGFRAME, rect.GetDU(), this, IDL_INPUTSTATUS);

	
	////Create Check Box////
	rect.Set(15, 205, 55, 10);
	m_CAutoRefreshIp.Create("Auto Refresh", WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_AUTOCHECKBOX, rect.GetDU(), this, IDB_AUTOREFRESHIP);
	m_CAutoRefreshIp.SetCheck(0);

	rect.Set(15, 120, 55, 10);
	m_CAutoRefreshRl.Create("Auto Refresh", WS_CHILD | WS_VISIBLE | BS_CHECKBOX | BS_AUTOCHECKBOX, rect.GetDU(), this, IDB_AUTOREFRESHRL);
	m_CAutoRefreshRl.SetCheck(0);

	rect.Set(15, 215, 55, 10);
	m_CAlarmNotifyIp.Create("Alarm Notify", WS_CHILD | BS_CHECKBOX | BS_AUTOCHECKBOX, rect.GetDU(), this, IDB_ALARMNOTIFYIP);
	m_CAlarmNotifyIp.SetCheck(0);

	rect.Set(15, 130, 55, 10);
	m_CAlarmNotifyRl.Create("Alarm Notify", WS_CHILD | BS_CHECKBOX | BS_AUTOCHECKBOX, rect.GetDU(), this, IDB_ALARMNOTIFYRL);
	m_CAlarmNotifyRl.SetCheck(0);


	OnCBSelectPort();
	OnCBSelectPort();
	OnRefreshRlStats();
	OnRefreshIpStats();
	
	return 0;
}


afx_msg void CMainWin::OnTimer(UINT nIDEvent)
{
	if(nIDEvent == IDT_INPUTS)
	{
		OnRefreshIpStats();
	}
	
	if(nIDEvent == IDT_RELAYS)
	{
		OnRefreshRlStats();
	}
}


afx_msg void CMainWin::OnCBSelectPort()
{
	char msg[100];
	CString port_stat;
	
	m_CBSelectPort.GetLBText(m_CBSelectPort.GetCurSel(), msg);
	
	if(Com.GetState())
	{
		Com.CloseCom();
	}
	
	if(Com.OpenCom(msg))
	{
		if(RelayBoard.AttachComControl(&Com)) PortState = true;
	}
	else 
	{
		PortState = false;
	}

	if(PortState)
	{
		port_stat.Format("Serial port: %s was successfully opened.", msg);
	}
	else
	{
		port_stat.Format("Serial port: %s failed to open.", msg);
	}

	m_EComState.SetWindowText(port_stat);
}


afx_msg void CMainWin::OnBActivate()
{
	int index;
	CString msg;

	if(!PortState) 
	{
		m_ERelayMessages.SetWindowText("No open com port found.");
		return;
	}

	index = m_LBRelayStatus.GetCurSel();
	if(index == LB_ERR)
	{
		m_ERelayMessages.SetWindowText("You must select a relay.");
		return;
	}

	RelayBoard.On(index + 1);

	msg.Format("Relay Number (%d)................%s", index + 1, RelayBoard.Status(index + 1) ? "Activated" : "Deactivated");
	
	m_ERelayMessages.SetWindowText(msg);
	
	m_LBRelayStatus.DeleteString(index);
	m_LBRelayStatus.InsertString(index, msg);

	m_LBRelayStatus.SetCurSel(index);
}


afx_msg void CMainWin::OnBDeactivate()
{
	int index;
	CString msg;

	if(!PortState) 
	{
		m_ERelayMessages.SetWindowText("No open com port found.");
		return;
	}

	index = m_LBRelayStatus.GetCurSel();
	if(index == LB_ERR)
	{
		m_ERelayMessages.SetWindowText("You must select a relay.");
		return;
	}
	
	RelayBoard.Off(index + 1);	

	msg.Format("Relay Number (%d)................%s", index + 1, RelayBoard.Status(index + 1) ? "Activated" : "Deactivated");
	
	m_ERelayMessages.SetWindowText(msg);
	
	m_LBRelayStatus.DeleteString(index);
	m_LBRelayStatus.InsertString(index, msg);

	m_LBRelayStatus.SetCurSel(index);
}


afx_msg void CMainWin::OnRefreshRlStats()
{
	int i;
	int cur_sel = 0;
	int status = 0;
	int alarm_notify = 0;
	CString msg;

	if(!PortState) 
	{
		m_ERelayMessages.SetWindowText("No open com port found.");
		return;
	}

	cur_sel = m_LBRelayStatus.GetCurSel();

	m_LBRelayStatus.ResetContent();
	for(i=0; i<8; i++)
	{
		status = RelayBoard.Status(i + 1);
		msg.Format("Relay Number (%d)................%s", i + 1, status ? "Activated" : "Deactivated");
		m_LBRelayStatus.AddString(msg);

		if(status == 1) alarm_notify = true;
	}

	if(alarm_notify && m_CAlarmNotifyRl.GetCheck())
	{
		PlaySound("alarm.wav", NULL, SND_ASYNC | SND_NOSTOP | SND_FILENAME);
	}

	m_ERelayMessages.SetWindowText("Relays refreshed.");
	
	m_LBRelayStatus.SetCurSel(cur_sel);
}


afx_msg void CMainWin::OnRefreshIpStats()
{
	int i;
	int cur_sel = 0;
	int status = 0;
	int alarm_notify = 0;
	CString msg;

	if(!PortState) 
	{
		m_EInputMessages.SetWindowText("No open com port found.");
		return;
	}

	cur_sel = m_LBInputStatus.GetCurSel();

	m_LBInputStatus.ResetContent();
	for(i=0; i<4; i++)
	{
		status = RelayBoard.InputStatus(i + 1);
		msg.Format("Input Number (%d)................%s", i + 1, status ? "Activated" : "Deactivated");
		m_LBInputStatus.AddString(msg);

		if(status == 1) alarm_notify = true;
	}

	if(alarm_notify && m_CAlarmNotifyIp.GetCheck())
	{
		PlaySound("alarm.wav", NULL, SND_ASYNC | SND_NOSTOP | SND_FILENAME);
	}

	m_EInputMessages.SetWindowText("Inputs refreshed.");

	m_LBInputStatus.SetCurSel(cur_sel);
}


afx_msg void CMainWin::OnCAutoRefreshIp()
{
	int state;
	state = m_CAutoRefreshIp.GetCheck();
	
	if(state == 0)
	{
		m_CAlarmNotifyIp.ShowWindow(SW_HIDE);
		m_EInputMessages.SetWindowText("Auto refreshing off.");
		KillTimer(IDT_INPUTS);
	}
	else
	{
		m_CAlarmNotifyIp.ShowWindow(SW_SHOW);
		m_EInputMessages.SetWindowText("Auto refreshing on. (every 10 seconds)");
		SetTimer(IDT_INPUTS, 10000, NULL);
	}
}


afx_msg void CMainWin::OnCAutoRefreshRl()
{
	int state;
	state = m_CAutoRefreshRl.GetCheck();
	
	if(state == 0)
	{
		m_CAlarmNotifyRl.ShowWindow(SW_HIDE);
		m_ERelayMessages.SetWindowText("Auto refreshing off.");
		KillTimer(IDT_RELAYS);
	}
	else
	{
		m_CAlarmNotifyRl.ShowWindow(SW_SHOW);
		m_ERelayMessages.SetWindowText("Auto refreshing on. (every 10 seconds)");
		SetTimer(IDT_RELAYS, 10000, NULL);
	}
}


BOOL CApp::InitInstance()
{
	INITCOMMONCONTROLSEX initControls;
	initControls.dwSize = sizeof(initControls);
	initControls.dwICC = ICC_TAB_CLASSES | ICC_BAR_CLASSES | ICC_UPDOWN_CLASS | ICC_LISTVIEW_CLASSES | ICC_DATE_CLASSES ;
	InitCommonControlsEx(&initControls);

	LPCSTR class_name;
	class_name = AfxRegisterWndClass(0, LoadStandardCursor(IDC_ARROW), (HBRUSH)GetStockObject(LTGRAY_BRUSH), LoadIcon(IDI_REMOTECONTROL));
	m_pMainWnd = new CMainWin(class_name);
	
	return 1;
}


CApp App;


BEGIN_MESSAGE_MAP(CMainWin, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_CBN_SELCHANGE(IDC_SELECTPORT, OnCBSelectPort)
	ON_COMMAND(IDB_ACTIVATE, OnBActivate)
	ON_COMMAND(IDB_DEACTIVATE, OnBDeactivate)
	ON_COMMAND(IDB_REFRESHRLSTATS, OnRefreshRlStats)
	ON_COMMAND(IDB_REFRESHIPSTATS, OnRefreshIpStats)
	ON_BN_CLICKED(IDB_AUTOREFRESHIP, OnCAutoRefreshIp)
	ON_BN_CLICKED(IDB_AUTOREFRESHRL, OnCAutoRefreshRl)
END_MESSAGE_MAP()


