
class CNoRect
{
public:
	CNoRect();
	CNoRect(int x, int y, int width, int height);

	void Set(int x, int y, int width, int height);
	RECT& Get(void);
	RECT GetDU(void);

	RECT rect;
};


CNoRect::CNoRect()
{
	Set(0, 0, 0, 0);
};

CNoRect::CNoRect(int x, int y, int width, int height)
{
	Set(x, y, width, height);
};

void CNoRect::Set(int x, int y, int width, int height)
{
	rect.left = x;
	rect.top = y;
	rect.right = x + width;
	rect.bottom = y + height;
}

RECT& CNoRect::Get(void)
{
	return rect;
}

RECT CNoRect::GetDU(void)
{
	RECT drect;
	long dux, duy;

	dux = LOWORD(GetDialogBaseUnits());
	duy = HIWORD(GetDialogBaseUnits());

	drect.left =	(rect.left * dux) / 4;
	drect.right =	(rect.right * dux) / 4;
	drect.top =		(rect.top * duy) / 8;
	drect.bottom =	(rect.bottom * duy) / 8;
 
	return drect;
}