/*

int map[32*32] = {   
9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,1,0,0,1,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,1,0,0,0,0,0,4,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,1,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,9,8,
};


    RayCaster Player;

     Player.SetViewport(mx/2-100, my/2-100, 200, 200);
     Player.SetWorld(32, 32, map);
     Player.SetCamera(3, 3, -45, 60);

     while(!keyPressed[1])
     {
          Flip();

          if(keyPressed[75])
          {
               Player.Angle -= 10;
          }

          if(keyPressed[77])
          {
               Player.Angle += 10;
          }
          
          if(keyPressed[72])
          {
               Player.Travel(5);
          }
 
          if(keyPressed[80])
          {
               Player.Travel(-5);
          }

          Player.CastRays();
     }

*/

#include "DirectX.h"
#include <math.h>
#include <iostream.h>

#ifndef _RAYCASTER_H
#define _RAYCASTER_H

class RayCaster
{
public:
     float X, Y;
     float XV, YV;
     float Angle;
     float FieldOfView;
     
     RayCaster();
     void SetViewport(int x, int y, int width, int height);
     void SetWorld(int width, int height, int *world);
     void SetCamera(int x, int y, float angle, int fieldofview);
     void Travel(float speed);
     void CastRays(void);
     
private:
     int ViewX, ViewY, ViewWidth, ViewHeight;
     int WorldWidth, WorldHeight, *World;

     float Sin360(float degrees){return (float)sin(degrees*.01745329252);}
     float Cos360(float degrees){return (float)cos(degrees*.01745329252);}
};

RayCaster::RayCaster()
{
     X=0; Y=0; 
     XV=0; YV=0;
     Angle=0; 
     FieldOfView = 60;
}

void RayCaster::SetViewport(int x, int y, int width, int height)
{
     ViewX = x;
     ViewY = y;
     ViewWidth = width;
     ViewHeight = height;
}

void RayCaster::SetWorld(int width, int height, int *world)
{
     WorldWidth = width;
     WorldHeight = height;
     World = world;
}

void RayCaster::SetCamera(int x, int y, float angle, int fieldofview)
{
     X = x*12;
     Y = y*12;
     Angle = angle;
     FieldOfView = fieldofview;
}

void RayCaster::Travel(float speed)
{
     float vx = speed*Cos360(Angle), vy = speed*Sin360(Angle);
     int x = X/12, y = Y/12;
     int fx = (X+vx)/12, fy = (Y+vy)/12; 

     if(World[(y*WorldWidth)+fx]==0) X+=vx;
     if(World[(fy*WorldWidth)+x]==0) Y+=vy;
}

void RayCaster::CastRays(void)
{
     float vlx = (ViewWidth/FieldOfView)+1;  //vertical lines per degree 
     float halffov = FieldOfView/2;          //half the field of view
     float rayx=0, rayy=0;                   //ray x,y position
     float rayxv=0, rayyv=0;                 //ray x,y vectors
     float raydist=0;                        //distance ray traveled
     int fx=0, fy=0;
     int color = 0;                          //color of what the ray hits
     int linex = 0;                          //vertical line drawing coords
     int linetop = 0;
     int linebottom = 0;
     float hproj = 0;                        //height projection
     float index=0;                          //angle index
                                    

     for(index=(Angle-halffov); index<(Angle+halffov); index++)  
     {
          rayx = X;
          rayy = Y;
          rayxv = Cos360(index);
          rayyv = Sin360(index);
          raydist = 0;
          color = 0;

          while(color==0)
          {
               rayx += rayxv;
               rayy += rayyv;
               raydist += .4;
               fx = (int)rayx/12;
               fy = (int)rayy/12;
               color = map[(fy*WorldWidth)+fx];
          }

          setfillstyle(1,color);
          hproj = (ViewHeight)/raydist;
          linetop = (ViewHeight/2) - hproj;
          linebottom = (ViewHeight/2) + hproj;
          bar(ViewX+linex, ViewY+linetop, ViewX+linex+vlx, ViewY+linebottom);
          linex += vlx;
     }

}

#endif

