
#ifndef _ENGINES_H
#define _ENGINES_H


#ifndef _USEFUL_MACROS
#define _USEFUL_MACROS
const double PI = 3.14159265358979323846264338327950288419716939937510f;
const double PI2 = PI * 2;
const double RADIAN = PI / 180; 

#define SIN360(theta) (float)sin((double)theta * RADIAN) 
#define COS360(theta) (float)cos((double)theta * RADIAN) 
#define TAN360(theta) (float)tan((double)theta * RADIAN)
#define SWAP(a,b) ((a)^=(b)^=(a)^=(b))
#define RGB16(r,g,b) (USHORT)((b%32) + ((g%64) << 6) + ((r%32) << 11))
#define RGB32(a,r,g,b) (UINT)((b) + ((g) << 8) + ((r) << 16) + ((a) << 24))
#endif

//////////////////////////////////////////////////////////////////

class RayCaster
{
public:
     float X, Y;
     float XV, YV;
     float Angle;
     float FieldOfView;
     
     RayCaster();
     void SetViewport(int x, int y, int width, int height);
     void SetWorld(int width, int height, float *world);
     void SetCamera(int x, int y, float angle, int fieldofview);
     void Travel(float speed);
     void CastRays(void);
     
private:
     int ViewX, ViewY, ViewWidth, ViewHeight;
     int WorldWidth, WorldHeight;
	 float *World;

     float Sin360(float degrees){return (float)sin(degrees*.01745329252);}
     float Cos360(float degrees){return (float)cos(degrees*.01745329252);}
};



/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////


////Ray Casting Engine//////////////////////////////////////////////////////////////////////////
RayCaster::RayCaster()
{
     X=0; Y=0; 
     XV=0; YV=0;
     Angle=0; 
     FieldOfView = 60;
}

void RayCaster::SetViewport(int x, int y, int width, int height)
{
     ViewX = x;
     ViewY = y;
     ViewWidth = width;
     ViewHeight = height;
}

void RayCaster::SetWorld(int width, int height, float *world)
{
     WorldWidth = width;
     WorldHeight = height;
     World = world;
}

void RayCaster::SetCamera(int x, int y, float angle, int fieldofview)
{
     X = (float)x*12;
     Y = (float)y*12;
     Angle = angle;
     FieldOfView = (float)fieldofview;
}

void RayCaster::Travel(float speed)
{
    float vx = speed*Cos360(Angle), vy = speed*Sin360(Angle);
    int x = (int)(X/12), y = (int)(Y/12);
    int rx, ry;

	rx = (int)(X+vx)/12;
	ry = (int)(Y+vy)/12;
		 
	if(!World[(y * WorldWidth) + rx])X+=vx;
	if(!World[(ry * WorldWidth) + x])Y+=vy;		 
}

void RayCaster::CastRays(void)
{
	DD_Fill_Rect(lpddsback,ViewX, ViewY, ViewWidth, ViewHeight/2, RGB32(0,150,30,40));
	DD_Fill_Rect(lpddsback,ViewX, ViewY+(ViewHeight/2), ViewWidth, ViewHeight/2, RGB32(0,100,120,0));
	
	float vlx = ((float)ViewWidth/FieldOfView)+1;  //vertical lines per degree 
    float halffov = FieldOfView/2;          //half the field of view
	float rayx=0, rayy=0;                   //ray x,y position
    float rayxv=0, rayyv=0;                 //ray x,y vectors
    float raydist=0;                        //distance ray traveled
    int fx=0, fy=0;
    int color = 0;                          //color of what the ray hits
    int linex=0, liney=0;
	int linewidth = 0;                          //vertical line drawing coords
    int lineheight = 0;
    int tmpx=0;
	float hproj = 0;                        //height projection
    float index=0;                          //angle index
                                    
    for(index=(Angle-halffov); index<(Angle+halffov); index++)  
    {
		rayx = X;
        rayy = Y;
        rayxv = Cos360(index);
        rayyv = Sin360(index);
        raydist = 0;
        color = 0;

        while(!color)
        { 
			rayx += rayxv;
			rayy += rayyv;
			raydist += (float).4;
			fx = (int)rayx/12;
			fy = (int)rayy/12;	
			color = (int) World[(fy*WorldWidth)+fx];
        }
		

		hproj = (float)ViewHeight/raydist;
		
		DD_Fill_Rect(lpddsback, ViewX+tmpx, ViewY+(ViewHeight/2)-(int)hproj, (int)vlx, (int)hproj*2, RGB32(0,(8*color),0,200));
		
		tmpx += (int)vlx;
	}

	for(fy=0; fy<WorldHeight; fy++)
	{
		for(fx=0; fx<WorldWidth; fx++)
		{
			color = (int) World[(fy*WorldWidth) +fx];
			if(color)
			{
				DD_Fill_Rect(lpddsback, fx*6, fy*6, 6, 6, RGB32(0, (8*color), 0, 0));
			}
		}
	}

	DD_Fill_Rect(lpddsback, (int)(X/2), (int)(Y/2), 3, 3, RGB32(0,231,63,31));
}


#endif

