// NetBackupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetBackup.h"
#include "NetBackupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WM_TIMER_NOTIFICATION WM_USER+0
#define WM_TRAY_NOTIFICATION WM_USER+5

#define ABS(a)	((a < 0) ? (-(a)) : (a))
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}


void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBackupDlg dialog

CNetBackupDlg::CNetBackupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetBackupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetBackupDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_NBLOGO);
}

void CNetBackupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetBackupDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNetBackupDlg, CDialog)
	//{{AFX_MSG_MAP(CNetBackupDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_TESTSETTINGS, OnTestsettings)
	ON_BN_CLICKED(ID_APPLYSETTINGS, OnApplysettings)
	ON_BN_CLICKED(ID_ADDFILE, OnAddfile)
	ON_BN_CLICKED(ID_REMOVEFILE, OnRemovefile)
	ON_BN_CLICKED(ID_REMOVEALL, OnRemoveall)
	ON_COMMAND(ID_NBSHOW, OnNBShow)
	ON_COMMAND(ID_NBHIDE, OnNBHide)
	ON_COMMAND(ID_NBABOUT, OnNBAbout)
	ON_COMMAND(ID_NBSHUTDOWN, OnNBShutdown)
	ON_BN_CLICKED(ID_CANCEL, OnCancel)
	ON_MESSAGE(WM_TRAY_NOTIFICATION, OnTrayNotification)
	ON_WM_TIMER()
	ON_BN_CLICKED(ID_ADDWILDCARD, OnAddWildCard)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CNetBackupDlg message handlers

BOOL CNetBackupDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_SysTray.Init(IDR_NBLOGO);
	m_SysTray.SetNotificationWnd(this, WM_TRAY_NOTIFICATION);
	m_SysTray.SetIcon(IDR_NBLOGO);

	DWORD i;
	DWORD count;
	DWORD tmp_time;
	char data[1000];
	DWORD size;
	CString regname;
	CString cmd_line;

	HideMe = 0;
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	char tmp_path[1000];
	GetCurrentDirectory(1000, tmp_path);
	FilePath = tmp_path;
			
	m_DomainEdit = (CEdit *) GetDlgItem(IDC_DOMAINEDIT);
	m_DirectoryEdit = (CEdit *) GetDlgItem(IDC_DIRECTORYEDIT);
	m_LoginEdit = (CEdit *) GetDlgItem(IDC_LOGINEDIT);
	m_PasswordEdit = (CEdit *) GetDlgItem(IDC_PASSWORDEDIT);
	m_TimePicker = (CDateTimeCtrl *) GetDlgItem(IDC_TIMEPICKER);
	m_FileList = (CListBox *) GetDlgItem(IDC_FILELIST);
	m_AutorunCheck = (CButton *) GetDlgItem(IDC_AUTORUN);
	m_ProgressBar = (CProgressCtrl *) GetDlgItem(IDC_PROGRESSBAR);
	
	m_DomainEdit->LimitText(1000);
	m_DirectoryEdit->LimitText(1000);
	m_LoginEdit->LimitText(1000);
	m_PasswordEdit->LimitText(1000);

	SendTime = 21600;
	m_TimePicker->SetTime(&SendTime);

	m_AutorunCheck->SetCheck(1);

	m_ProgressBar->SetRange32(0, 0);
	m_ProgressBar->SetPos(0);
   

	if(ERROR_SUCCESS != Registry.Open(HKEY_CURRENT_USER, "Software\\InterFaces\\NetBackup"))
	{
		Registry.Create(HKEY_CURRENT_USER, "Software\\InterFaces\\NetBackup");
		RunIntro();
	}
	else
	{		
		size = 1000;
		if(ERROR_SUCCESS == Registry.QueryValue(data, "DomainEdit", &size))
		{
			m_DomainEdit->SetWindowText(data);
			Domain = data;
		}
		
		size = 1000;
		if(ERROR_SUCCESS == Registry.QueryValue(data, "DirectoryEdit", &size))
		{
			m_DirectoryEdit->SetWindowText(data);
			Directory = data;
		}

		size = 1000;
		if(ERROR_SUCCESS == Registry.QueryValue(data, "LoginEdit", &size))
		{
			m_LoginEdit->SetWindowText(data);
			Login = data;
		}
			
		size = 1000;
		if(ERROR_SUCCESS == Registry.QueryValue(data, "PasswordEdit", &size))
		{
			for(int i=0; i<1000; i++)
			{
				if(data[i] != NULL) data[i]--;
			}

			m_PasswordEdit->SetWindowText(data);
			Password = data;
		}
		
		if(ERROR_SUCCESS != Registry.QueryValue(count, "NumFiles")) count = 0;
		for(i=0; i<count; i++)
		{
			size = 1000;
			regname.Format("FileListEntry%d", i);
			
			if(ERROR_SUCCESS == Registry.QueryValue(data, regname, &size))
			{
				m_FileList->AddString(data);
			}
		}

		if(ERROR_SUCCESS == Registry.QueryValue(tmp_time, "SendTime"))
		{
			SendTime = tmp_time;
			m_TimePicker->SetTime(&SendTime);
		}

		if(ERROR_SUCCESS == Registry.QueryValue(check_val, "AutoRunCheck"))
		{
			m_AutorunCheck->SetCheck(check_val);
		}

		cmd_line = GetCommandLine();
		if(-1 != cmd_line.Find("RunHidden"))
		{
			HideMe = 1;
		}
	}

	SetTimer(WM_TIMER_NOTIFICATION, 1000, NULL);
	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CNetBackupDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetBackupDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}


HCURSOR CNetBackupDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CNetBackupDlg::OnTestsettings() 
{
	m_DomainEdit->GetWindowText(Domain);
	m_DirectoryEdit->GetWindowText(Directory);
	m_LoginEdit->GetWindowText(Login);
	m_PasswordEdit->GetWindowText(Password);
	check_val = m_AutorunCheck->GetCheck();

	BackupFiles();
}


void CNetBackupDlg::OnApplysettings() 
{
	DWORD tmp_time;
	DWORD i;
	DWORD count;
	CString regname;
	char data[1000];

	m_DomainEdit->GetWindowText(data, 1000);
	Registry.SetValue(data,"DomainEdit");
	Domain = data;
	
	m_DirectoryEdit->GetWindowText(data, 1000);
	Registry.SetValue(data,"DirectoryEdit");
	Directory = data;

	m_LoginEdit->GetWindowText(data, 1000);
	Registry.SetValue(data,"LoginEdit");
	Login = data;

	m_PasswordEdit->GetWindowText(data, 1000);
	Password = data;
	for(i=0; i<1000; i++)
	{
		if(data[i] != NULL) data[i]++;
	}
	Registry.SetValue(data,"PasswordEdit");

	count = m_FileList->GetCount();
	if(count == LB_ERR) count = 0;
	Registry.SetValue(count, "NumFiles");
	
	for(i=0; i<count; i++)
	{
		regname.Format("FileListEntry%d", i);
		m_FileList->GetText(i, data);
		Registry.SetValue(data, regname);
	}

	m_TimePicker->GetTime(SendTime);
	tmp_time = SendTime.GetTime();
	Registry.SetValue(tmp_time, "SendTime");

	check_val = m_AutorunCheck->GetCheck();
	Registry.SetValue(check_val, "AutoRunCheck");

	CRegKey reg;
	if(check_val)
	{
		if(ERROR_SUCCESS == reg.Open(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\Run"))
		{
			if(ERROR_SUCCESS != reg.SetValue(FilePath+"\\NetBackup.exe RunHidden", "NetBackup"))
			{
				MessageBox("ERROR: Failed to implement autorun component using the registry.");
			}
		}
	}
	else
	{
		if(ERROR_SUCCESS == reg.Open(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\Run"))
		{
			reg.DeleteValue("NetBackup");
		}
		else
		{
			MessageBox("ERROR: Failed to remove autorun component from the registry");
		}
	}
	//HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run
}


void CNetBackupDlg::OnAddfile() 
{
	POSITION pos;
	CString name;
	char buffer[10000];

	CFileDialog FileDialog(1, NULL, NULL, OFN_ALLOWMULTISELECT);
	FileDialog.m_ofn.lpstrFile = buffer;
	FileDialog.m_ofn.nMaxFile = 10000;

	FileDialog.DoModal();

	pos = FileDialog.GetStartPosition();
	while(pos != NULL)
	{
		m_FileList->AddString(FileDialog.GetNextPathName(pos));
	}
}


void CNetBackupDlg::OnRemovefile() 
{
	int selection;
	selection = m_FileList->GetCurSel();

	if(selection == LB_ERR)
	{
		MessageBox("You must select a file to remove!");
		return;
	}

	m_FileList->DeleteString(selection);
}


void CNetBackupDlg::OnRemoveall() 
{
	m_FileList->ResetContent();	
}


void CNetBackupDlg::RunIntro(void)
{
	CNBIntro Intro(this);
	Intro.DoModal();
}


int CNetBackupDlg::BackupFiles(void)
{
	BOOL isVisible;
	DWORD count, i, pos;
	CString path;
	CString data;
	CString fname;
	CFileFind search;
	CInternetSession NetSession;
	CFtpConnection *FtpConnection;

	isVisible = IsWindowVisible();
	
	if(isVisible == 0)
	{
		ShowWindow(SW_SHOW);
		UpdateWindow();
		Sleep(2000);
	}

	FtpConnection = NetSession.GetFtpConnection(Domain, Login, Password);

	if(!Directory.IsEmpty())
	{
		if(!FtpConnection->SetCurrentDirectory(Directory))
		{
			if(IDYES == MessageBox("The specified destination directory cannot be found, do you wish to create it?", NULL, MB_YESNO))
			{
				FtpConnection->CreateDirectory(Directory);
				FtpConnection->SetCurrentDirectory(Directory);
			}
			else
			{
				if(IDNO == MessageBox("Do you still wish to continue, placing the files in a default directory?", NULL, MB_YESNO))
				{
					return 1;
				}
			}
		}
	}

	count = m_FileList->GetCount();

	if(count > 0)
	{
		m_ProgressBar->SetRange32(0, count);
		m_ProgressBar->SetPos(0);
		m_ProgressBar->SetStep(1);
	}
	
	for(i=0; i<count; i++)
	{
		m_ProgressBar->StepIt();
				
		m_FileList->GetText(i, data);
		
		if(-1 == data.Find("*"))
		{
			path = data;
			fname = path;
			pos = fname.ReverseFind('\\');
			if(-1 == pos) pos = 0;
			fname.Delete(0, pos + 1);
			FtpConnection->PutFile(path, fname);
		}
		else
		{
			if(search.FindFile(data))
			{
				path = search.GetFilePath();
				fname = search.GetFileName();
				FtpConnection->PutFile(path, fname);
			}

			while(search.FindNextFile())
			{
				path = search.GetFilePath();
				fname = search.GetFileName();
				FtpConnection->PutFile(path, fname);
			}
		}
	}

	m_ProgressBar->SetPos(0);

	if(isVisible == 0)
	{
		ShowWindow(SW_HIDE);
	}
	
	return 1;
}

void CNetBackupDlg::OnCancel() 
{
	if(IDYES == MessageBox("Are you sure you want to quit?", NULL, MB_YESNO))
	{
		CDialog::OnCancel();	
		KillTimer(WM_TIMER_NOTIFICATION);
	}
}


LRESULT CNetBackupDlg::OnTrayNotification(WPARAM wp, LPARAM lp)
{
	
	return m_SysTray.OnTrayNotification(wp, lp);
}


afx_msg void CNetBackupDlg::OnNBShow()
{
	ShowWindow(SW_SHOW);
}

afx_msg void CNetBackupDlg::OnNBHide()
{
	ShowWindow(SW_HIDE);
}

afx_msg void CNetBackupDlg::OnNBAbout()
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

afx_msg void CNetBackupDlg::OnNBShutdown()
{
	KillTimer(WM_TIMER_NOTIFICATION);
	PostQuitMessage(1);
}

afx_msg void CNetBackupDlg::OnTimer(UINT ID)
{
	long time_curr = 0;
	long time_send = 0;
	CTime CurrTime;
	static BOOL flipflop = 1;

	if(HideMe == 1)
	{
		HideMe = 0;
		ShowWindow(SW_HIDE);
	}
	
	CurrTime = CTime::GetCurrentTime();

	time_curr  = (CurrTime.GetHour() * 60 * 60);
	time_curr += (CurrTime.GetMinute() * 60);
	time_curr += (CurrTime.GetSecond());

	time_send  = (SendTime.GetHour() * 60 * 60);
	time_send += (SendTime.GetMinute() * 60);
	time_send += (SendTime.GetSecond());

	if(ABS(time_curr - time_send) < 10)
	{
		if(flipflop == 1)
		{
			flipflop = 0;
			BackupFiles();
		}
	}
	else
	{
		flipflop = 1;
	}
}



void CNetBackupDlg::OnAddWildCard() 
{
	CWildCard wildcard;
	
	wildcard.DoModal();	
	
	if(!wildcard.data.IsEmpty())
	{
		m_FileList->AddString(wildcard.data);
	}

/*
	CFileFind ff;

	ff.FindFile("C:\\Programming\\JBuilder\\*.txt");
	while(1)
	{
		m_FileList->AddString(ff.GetFileName());
		if(!ff.FindNextFile()) break;
	}
*/
}
