/************************************************************************

  CS 318: MP3 -- The World in Motion
    see http://www-courses.cs.uiuc.edu/~cs318/mp/mp3.html for details

  NAME   : Benjamin Gottemoller
  NET ID : gottemol

 ************************************************************************/


#include <gfx/gui.h>
#include <gfx/gl.h>
#include <gfx/gfx.h>
#include <gfx/gltools.h>
#include <gfx/vec4.h>
#include <vector>

#include <FL/fl_color_chooser.h>
#include <FL/fl_file_chooser.h>
#include <FL/filename.h>
#include <FL/fl_ask.h>
#include <FL/fl.h>
#include <FL/fl_window.h>
#include <FL/fl_input.h>
#include <FL/fl_button.h>
#include <FL/fl_return_button.h>
#include <FL/fl_box.h>

#include "framework.h"
#include "GLEngine.h"


GL_Material red;
GL_Material gold;
GL_Material blue_white;
GL_Material blue;

GUI gui;


void cb_open()
{
	char *file = NULL; 
	file = fl_file_chooser("Select model file to open", "*.{cyl, txt}", NULL);

	gui.LoadCylinder(file, &blue);
}

void cb_quit()
{
    exit(0);
}

void cb_fountain_texture()
{
	char *filename = fl_file_chooser("Select texture to use", "*.{bmp}", NULL);

	if(filename)
	{
		gui.LoadTexture(filename, 2);
	}
}

void cb_cube_texture()
{
	char *filename = fl_file_chooser("Select texture to use", "*.{bmp}", NULL);

	if(filename)
	{
		gui.LoadTexture(filename, 3);
	}
}

void cb_weapon_texture()
{
	char *filename = fl_file_chooser("Select texture to use", "*.{bmp}", NULL);

	if(filename)
	{
		gui.LoadTexture(filename, 1);
	}
}

void cb_fountain_spring_texture()
{
	char *filename = fl_file_chooser("Select texture to use", "*.{bmp}", NULL);

	if(filename)
	{
		gui.LoadTexture(filename, 4);
	}
}

void cb_camera_play()
{
	gui.Camera.IsAnimationPlaying = 1;
}

void cb_camera_stop()
{
	gui.Camera.IsAnimationPlaying = 0;
}

void cb_camera_reset()
{
	gui.Camera.KFS.Reset();
}

void cb_character1_play()
{
	gui.world_objects[0]->IsAnimationPlaying = 1;
}

void cb_character1_stop()
{
	gui.world_objects[0]->IsAnimationPlaying = 0;
}

void cb_character1_reset()
{
	gui.world_objects[0]->KFS.Reset();
}

void cb_character2_play()
{
	gui.Clunky.IsAnimationPlaying = 1;
}

void cb_character2_stop()
{
	gui.Clunky.IsAnimationPlaying = 0;
}

void cb_character2_reset()
{
	gui.Clunky.ResetAnimation();
}

void cb_show_path()
{
	gui.IsInterpolationPathVisible = 1;
}

void cb_hide_path()
{
	gui.IsInterpolationPathVisible = 0;
}

void cb_enable_particles()
{
	gui.Sparky.IsParticleEngineActive = 1;
}

void cb_disable_particles()
{
	gui.Sparky.IsParticleEngineActive = 0;
}

void cb_bright_lights()
{
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHT1);
}

void cb_soft_lights()
{
	glDisable(GL_LIGHT0);
	glEnable(GL_LIGHT1);	
}

void cb_dark_lights()
{
	glDisable(GL_LIGHT0);
	glDisable(GL_LIGHT1);	
}

static Fl_Menu_Item menu_layout[] =
{
    MXGUI_BEGIN_MENU("&File")
//    {"Load Model ...", FL_CTRL+'o', (Fl_Callback *)cb_open, (void *)NULL},
    {"&Quit", FL_CTRL+'q', (Fl_Callback *)cb_quit, (void *)NULL},
    MXGUI_END_MENU

    MXGUI_BEGIN_MENU("&Set Textures")
	{"Particle Fountain (Free Particles)...", 0, (Fl_Callback *)cb_fountain_texture, (void *)NULL},
	{"Particle Fountain (Spring Particles)...", 0, (Fl_Callback *)cb_fountain_spring_texture, (void *)NULL},
    {"Cube ...", 0, (Fl_Callback *)cb_cube_texture, (void *)NULL},
    {"Weapon ...", 0, (Fl_Callback *)cb_weapon_texture, (void *)NULL},
    MXGUI_END_MENU

    MXGUI_BEGIN_MENU("&Animation")
	MXGUI_BEGIN_MENU("&Camera")
	{"Play", 0, (Fl_Callback *)cb_camera_play, (void *)NULL, FL_MENU_RADIO},
	{"Stop", 0, (Fl_Callback *)cb_camera_stop, (void *)NULL, FL_MENU_RADIO | FL_MENU_VALUE},
	{"Reset", 0, (Fl_Callback *)cb_camera_reset, (void *)NULL},
    MXGUI_END_MENU
	MXGUI_BEGIN_MENU("&Character1 (Flying Cone)")
	{"Play", 0, (Fl_Callback *)cb_character1_play, (void *)NULL, FL_MENU_RADIO},
	{"Stop", 0, (Fl_Callback *)cb_character1_stop, (void *)NULL, FL_MENU_RADIO | FL_MENU_VALUE},
	{"Reset", 0, (Fl_Callback *)cb_character1_reset, (void *)NULL},
    MXGUI_END_MENU
	MXGUI_BEGIN_MENU("&Character2 (Clunky the hierarchical object)")
	{"Play", 0, (Fl_Callback *)cb_character2_play, (void *)NULL, FL_MENU_RADIO},
	{"Stop", 0, (Fl_Callback *)cb_character2_stop, (void *)NULL, FL_MENU_RADIO | FL_MENU_VALUE},
	{"Reset", 0, (Fl_Callback *)cb_character2_reset, (void *)NULL},
    MXGUI_END_MENU	
	{"Show Interpolation Path", 0, (Fl_Callback *)cb_show_path, (void *)NULL, FL_MENU_RADIO | FL_MENU_VALUE},
	{"Hide Interpolation Path", 0, (Fl_Callback *)cb_hide_path, (void *)NULL, FL_MENU_RADIO},
	MXGUI_END_MENU

    MXGUI_BEGIN_MENU("&Particles")
	{"Enabled", 0, (Fl_Callback *)cb_enable_particles, (void *)NULL, FL_MENU_RADIO | FL_MENU_VALUE},
	{"Disabled", 0, (Fl_Callback *)cb_disable_particles, (void *)NULL, FL_MENU_RADIO},
    MXGUI_END_MENU

    MXGUI_BEGIN_MENU("&Lights")
	{"Bright", 0, (Fl_Callback *)cb_bright_lights, (void *)NULL, FL_MENU_RADIO | FL_MENU_VALUE},
	{"Soft", 0, (Fl_Callback *)cb_soft_lights, (void *)NULL, FL_MENU_RADIO},
	{"Dark", 0, (Fl_Callback *)cb_dark_lights, (void *)NULL, FL_MENU_RADIO},
    MXGUI_END_MENU

    MXGUI_FINISH_MENUBAR
};

void CreateClunky(void)
{
	int i = 0;
	float x = 0, y = 0, z = 0;

	gui.Clunky.InitModel(2, 2);
	gui.Clunky.Position = VECTOR3(0, 1.0f, 0);
	gui.Clunky.Center = VECTOR3(0, 0, 0);
	gui.Clunky.Joint = VECTOR3(0, 0, 0);
	gui.Clunky.SetupProperties(&blue, &(gui.Timer));
	{
		gui.Clunky.Children[0].InitModel(1, 1);
		gui.Clunky.Children[0].Center = VECTOR3(0, 0, 0);
		gui.Clunky.Children[0].Joint = VECTOR3(0, 0, 0.35f);
		gui.Clunky.Children[0].Yaw = 0;
		gui.Clunky.Children[0].SetupProperties(&gold, &(gui.Timer));
		{	
			gui.Clunky.Children[0].Children[0].InitModel(2, 1);
			gui.Clunky.Children[0].Children[0].Center = VECTOR3(0, 0, 0.5);
			gui.Clunky.Children[0].Children[0].Joint = VECTOR3(0, 0, 0.5f);
			gui.Clunky.Children[0].Children[0].Yaw = 0;
			gui.Clunky.Children[0].Children[0].Pitch = PI/2;
			gui.Clunky.Children[0].Children[0].SetupProperties(&red, &(gui.Timer));
			{
				gui.Clunky.Children[0].Children[0].Children[0].InitModel(0, 1);
				gui.Clunky.Children[0].Children[0].Children[0].Center = VECTOR3(0, 0, 0.5f);
				gui.Clunky.Children[0].Children[0].Children[0].Joint = VECTOR3(0, 0, 0.5f);
				gui.Clunky.Children[0].Children[0].Children[0].Yaw = 0;
				gui.Clunky.Children[0].Children[0].Children[0].Pitch = PI/2;
				gui.Clunky.Children[0].Children[0].Children[0].SetupProperties(&blue_white, &(gui.Timer));

				gui.Clunky.Children[0].Children[0].Children[1].InitModel(0, 1);
				gui.Clunky.Children[0].Children[0].Children[1].Center = VECTOR3(0, 0, 0.5f);
				gui.Clunky.Children[0].Children[0].Children[1].Joint = VECTOR3(0, 0, -0.5f);
				gui.Clunky.Children[0].Children[0].Children[1].Yaw = 0;
				gui.Clunky.Children[0].Children[0].Children[1].Pitch = PI/2;
				gui.Clunky.Children[0].Children[0].Children[1].SetupProperties(&blue_white, &(gui.Timer));
			}
		}

		gui.Clunky.Children[1].InitModel(1, 1);
		gui.Clunky.Children[1].Center = VECTOR3(0, 0, 0);
		gui.Clunky.Children[1].Joint = VECTOR3(0, 0, -0.35f);
		gui.Clunky.Children[1].Yaw = PI;
		gui.Clunky.Children[1].SetupProperties(&gold, &(gui.Timer));
		{	
			gui.Clunky.Children[1].Children[0].InitModel(2, 1);
			gui.Clunky.Children[1].Children[0].Center = VECTOR3(0, 0, 0.5);
			gui.Clunky.Children[1].Children[0].Joint = VECTOR3(0, 0, 0.5f);
			gui.Clunky.Children[1].Children[0].Yaw = 0;
			gui.Clunky.Children[1].Children[0].Pitch = PI/2;
			gui.Clunky.Children[1].Children[0].SetupProperties(&red, &(gui.Timer));
			{
				gui.Clunky.Children[1].Children[0].Children[0].InitModel(0, 1);
				gui.Clunky.Children[1].Children[0].Children[0].Center = VECTOR3(0, 0, 0.5f);
				gui.Clunky.Children[1].Children[0].Children[0].Joint = VECTOR3(0, 0, 0.5f);
				gui.Clunky.Children[1].Children[0].Children[0].Yaw = 0;
				gui.Clunky.Children[1].Children[0].Children[0].Pitch = PI/2;
				gui.Clunky.Children[1].Children[0].Children[0].SetupProperties(&blue_white, &(gui.Timer));

				gui.Clunky.Children[1].Children[0].Children[1].InitModel(0, 1);
				gui.Clunky.Children[1].Children[0].Children[1].Center = VECTOR3(0, 0, 0.5f);
				gui.Clunky.Children[1].Children[0].Children[1].Joint = VECTOR3(0, 0, -0.5f);
				gui.Clunky.Children[1].Children[0].Children[1].Yaw = 0;
				gui.Clunky.Children[1].Children[0].Children[1].Pitch = PI/2;
				gui.Clunky.Children[1].Children[0].Children[1].SetupProperties(&blue_white, &(gui.Timer));
			}
		}
	}

	gui.Clunky.LoadKeyFrames("./key_frames/clunky");
}

main(int argc, char *argv[])
{
	int result = 0;
	float x = 0, y = 0;
	int i = 0, j = 0;
	Sphere *s = NULL;
	Cylinder *c = NULL;

    gui.initialize(argc, argv, menu_layout);
	gui.animate(1);

    red.Diffuse = COLOR(0.85f, 0.025f, 0.025f, 1.0f);
	red.Specular = red.Diffuse;
	red.Ambient = red.Diffuse;
    red.Power = 33.0f;

    gold.Diffuse = COLOR(0.8f, 0.8f, 0.2f, 1.0f);
    gold.Specular = gold.Diffuse * 0.5f;
	gold.Ambient = gold.Diffuse;
    gold.Power = 33.0f;

	blue_white.Diffuse = COLOR(160.0f / 256.0f, 170.0f / 256.0f, 200.0f / 256.0f, 1.0f);
	blue_white.Specular = blue_white.Diffuse;
	blue_white.Ambient = blue_white.Diffuse;
	blue_white.Power = 33.0f;

	blue.Diffuse = COLOR(60.0f / 256.0f, 70.0f / 256.0f, 140.0f / 256.0f, 1.0f);
	blue.Specular = blue.Diffuse;
	blue.Ambient = blue.Diffuse;
	blue.Power = 33.0f;

	c = new Cylinder("./models/cone.cyl", 60, 40, VECTOR3(2, 8.0f, 0), &blue, &gui.Timer);
	c->Position = VECTOR3(8.0f, 8.0f, 0);
	c->Yaw = PI;
	c->KFS.LoadKeys("./key_frames/character_key_frames.cfg");
	gui.world_objects.push_back(c);	

	CreateClunky();

	gui.IsInterpolationPathVisible = 1;

	result = gui.run();

	while(gui.world_objects.size() > 0)
	{
		delete (gui.world_objects.back());
		gui.world_objects.pop_back();
	}

	return result;
}