/************************************************************************

  CS 318: MP3 -- The World in Motion
    see http://www-courses.cs.uiuc.edu/~cs318/mp/mp3.html for details

  NAME   : Benjamin Gottemoller
  NET ID : gottemol

 ************************************************************************/

#ifndef _FRAMEWORK_H_
#define _FRAMEWORK_H_


#include <gfx/gui.h>
#include <gfx/gl.h>
#include <gfx/gfx.h>
#include <gfx/gltools.h>
#include <gfx/vec4.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glaux.h>
#include <vector>

#include <FL/fl_color_chooser.h>
#include <FL/fl_file_chooser.h>
#include <FL/filename.h>
#include <FL/fl_ask.h>
#include <FL/fl.h>
#include <FL/fl_window.h>
#include <FL/fl_input.h>
#include <FL/fl_button.h>
#include <FL/fl_return_button.h>
#include <FL/fl_box.h>

#include "GLEngine.h"

class GUI : public MxGUI
{
protected:
    bool doing_selection;      

public:
    int selected_object;       

public:
    GUI() : Camera(&Timer)
	{
		doing_selection = false;
		selected_object = opengl_pick_nil;
    }

    virtual void setup_for_drawing();
    virtual void draw_contents();
    virtual bool mouse_down(int *where, int which);
    virtual bool mouse_drag(int *where, int *last, int which);
	virtual bool key_press(int key);

	void InitializeWorld(void);
	void UpdateWorld(void);

	void LoadTexture(char *file, int id);
	void LoadCylinder(char *file, GL_Material *material);
	void ProcessInput(void);

	int IsInterpolationPathVisible;

	GL_HierarchicalModel Clunky;
	GL_Camera Camera;
	GL_ParticleSystem Sparky;
	GL_Level Scene;

	GL_FrameRateTracker Timer;

	std::vector<GL_Object *> world_objects;
};

#endif