
/************************************************************************

  CS 318: MP3 -- The World in Motion
    see http://www-courses.cs.uiuc.edu/~cs318/mp/mp3.html for details

  NAME   : Benjamin Gottemoller
  NET ID : gottemol

 ************************************************************************/

#include "framework.h"

void GUI::setup_for_drawing()
{
	static int flag = 1;

	if(flag == 0)
	{
		char msg[300];
		sprintf(msg, "%s%s%s", "Reinitialize world? ('No' is recommended but could ",
			    "result in lost textures on cheaper video cards...'Yes' has ",
				"problems of its own)");
		if(fl_choice(msg, "No", "Yes", NULL))
		{
			flag = 1;
		}
		else
		{
			flag = 0;
		}
	}

	if(flag)
	{
		COLOR ambient_light(0.3f, 0.3f, 0.5f, 1.0f);

		glClearColor(20.0f/256.0f, 30.0f/256.0f, 40.0f/256.0f, 1.0f);

		glEnable(GL_DEPTH_TEST);
		glEnable(GL_NORMALIZE);	

		glEnable(GL_LIGHTING);
		glLightModelfv(GL_LIGHT_MODEL_AMBIENT, (float *)(&ambient_light));
		glShadeModel(GL_SMOOTH);

		const Vec4f light0_pos(0.0f, 5.0f, 5.0f, 0.0f);
		const Vec4f light0_rgb(1.0f, 1.0f, 1.0f, 1.0f);
		glLightfv(GL_LIGHT0, GL_POSITION, light0_pos);
		glLightfv(GL_LIGHT0, GL_DIFFUSE, light0_rgb);
		glLightfv(GL_LIGHT0, GL_SPECULAR, light0_rgb);
		glEnable(GL_LIGHT0);

		const Vec4f light1_pos(5.0f, -5.0f, 5.0f, 0.0f);
		const Vec4f light1_rgb(0.8f, 0.2f, 0.2f, 1.0f);
		glLightfv(GL_LIGHT1, GL_POSITION, light1_pos);
		glLightfv(GL_LIGHT1, GL_DIFFUSE, light1_rgb);
		glLightfv(GL_LIGHT1, GL_SPECULAR, light1_rgb);
		glEnable(GL_LIGHT1);

		glEnable(GL_TEXTURE_2D);							
		glClearDepth(1.0f);					
		glDepthFunc(GL_LEQUAL);								
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	
		
		InitializeWorld();
	}
	flag = 0;
}

void GUI::InitializeWorld(void)
{
	SetCursorPos(GetSystemMetrics(SM_CXSCREEN) / 2, GetSystemMetrics(SM_CYSCREEN) / 2);

	LoadTexture("./textures/plasma.bmp", 1);
	LoadTexture("./textures/flame.bmp", 2);
	LoadTexture("./textures/egypt_large.bmp", 3);
	LoadTexture("./textures/plasma.bmp", 4);

	Sparky.Initialize(1000);
	Sparky.SetCamera(&Camera);

	Timer.Initialize();

	Camera.KFS.LoadKeys("./key_frames/camera_key_frames.cfg");
}

void GUI::UpdateWorld(void)
{
	static float angle = 0;
	int a = 12, b = 2, c = 12;
	float xv, yv, zv;
	int particle1 = 0, particle2 = 0;

	angle += 0.1f;
	xv = 0.07f * (float)sin(angle);
	yv = 0.222f + (float)(rand()%b - (b/2)) / 100.0f;
	zv = 0.07 * (float)cos(angle);

	Sparky.AddParticle(2, 0.0f, -9.9f, 0.0f, xv, yv, zv, 0.1f, 
					   COLOR(130, 140, 200, 255), 250, 48.0f);

	Sparky.AddParticle(2, 0.0f, -9.9f, 0.0f, -xv, yv, -zv, 0.1f, 
					   COLOR(30, 200, 60, 255), 250, 48.0f);


	xv = 0.04f * (float)sin(angle);
	yv = 0.0f;
	zv = 0.04f * (float)cos(angle);

	//Create Spring Particles :)
	particle1 = Sparky.AddParticle(4, -9.9f, 0.0f, 0.0f,  xv, yv, zv, 0.1f, 
								   COLOR(100, 100, 200, 255), 250, 48.0f);

	particle2 = Sparky.AddParticle(4, -9.9f, 1.0f, 0.0f,  xv, yv, -zv, 0.1f, 
								   COLOR(100, 100, 200, 255), 200, 48.0f);	
	
	Sparky.ConnectPair(particle1, particle2, (float)(rand()%100) / 500.0f, 0.91f);


	particle1 = Sparky.AddParticle(4, 9.9f, 0.0f, 0.0f,  -xv, yv, zv, 0.1f, 
								   COLOR(100, 100, 200, 255), 250, 48.0f);

	particle2 = Sparky.AddParticle(4, 9.9f, 1.0f, 0.0f,  -xv, yv, -zv, 0.1f, 
								   COLOR(100, 100, 200, 255), 200, 48.0f);	
	
	Sparky.ConnectPair(particle1, particle2, (float)(rand()%100) / 500.0f, 0.91f);


	xv = 0.07f * (float)sin(angle);
	yv = 0.2273f + (float)(rand()%4 - (b/4)) / 100.0f;
	zv = 0.07f * (float)cos(angle);

	//Create More Spring Particles :)
	particle1 = Sparky.AddParticle(4, 0.0f, -9.9f, 0.0f,  xv, yv, zv, 0.1f, 
								   COLOR(100, 100, 200, 255), 300, 58.0f);

	particle2 = Sparky.AddParticle(4, 0.0f, -9.9f, 0.0f, -xv, yv, -zv, 0.1f, 
								   COLOR(100, 100, 200, 255), 300, 58.0f);	
	
	Sparky.ConnectPair(particle1, particle2, (float)(rand()%100) / 500.0f, 0.91f);

	Sparky.Update();

	for(int i=0; i<world_objects.size(); i++)
    {
	    world_objects[i]->Update();
    }
}

void GUI::draw_contents()
{
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

	Timer.Update();

	ProcessInput();
	UpdateWorld();
	
    if(!doing_selection)
    {
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();

		Camera.SetupCamera((float)canvas->w(), (float)canvas->h());
		Camera.Look();
    }

    glMatrixMode(GL_MODELVIEW);

	Scene.Render();

	glColor4f(0.3f, 0.3f, 0.3f, 0.8f);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	for(int i=0; i<world_objects.size(); i++)
    {
		if(doing_selection) glLoadName(i);

		glPushMatrix();
		world_objects[i]->Render();
		glPopMatrix();

		if(IsInterpolationPathVisible)
		{
			world_objects[i]->KFS.RenderKeyPath();
		}
    }
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);

    if( selected_object!=opengl_pick_nil && !doing_selection )
    {
		world_objects[selected_object]->RenderBoundingBox();
    }

	Sparky.Render();

	Clunky.UpdateAndRenderHierarchy();

	if(IsInterpolationPathVisible)
	{
		Camera.KFS.RenderKeyPath();
		Clunky.RenderKeyPath();
	}

}

bool GUI::mouse_down(int *where, int which)
{
    canvas->make_current();

    if(which == 1)
    {
		doing_selection = true;
		GLuint buffer[128];
		begin_opengl_pick(where, 1.0, buffer, 128);
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		Camera.SetupCamera((float)canvas->w(), (float)canvas->h());
		Camera.Look();
		draw_contents();
		glPopMatrix();
		selected_object = complete_opengl_pick(buffer);
		doing_selection = false;

		return 1;
    }

    return 0;
}

bool GUI::mouse_drag(int *where, int *last, int which)
{
    if( which==1 && selected_object!=opengl_pick_nil )
    {
		GL_Object *s = world_objects[selected_object];

		Vec3 world_where, world_last;
		unproject_pixel(where, world_where);
		unproject_pixel(last, world_last);

		Vec3 delta = 100.*(world_where - world_last);
		s->Position += VECTOR3(delta[0], delta[1], delta[2]);

		return 1;
    }

	return 0;
}

bool GUI::key_press(int key)
{

	return 1;
}

void GUI::ProcessInput(void)
{
	static float speed = 0.11f;
	static float angular_speed = 0.005f;
	
	static int mouse_toggle = 0;
	POINT mouse;
	static float mouse_last_x = GetSystemMetrics(SM_CXSCREEN) / 2.0f, mouse_last_y = GetSystemMetrics(SM_CYSCREEN) / 2.0f;
	float dx = 0, dy = 0;

	GetCursorPos(&mouse);

	dx = mouse.x - mouse_last_x;
	dy = mouse.y - mouse_last_y;


	if(KEY_DOWN(VK_ESCAPE)) exit(0);

	if(mouse_toggle)
	{
		Camera.Rotate(CAMERA_YAW, -dx * angular_speed);
		Camera.Rotate(CAMERA_PITCH, dy * angular_speed);

		if(KEY_DOWN(VK_LBUTTON))
		{
			Sparky.AddParticle(1, Camera.Position.x, Camera.Position.y, Camera.Position.z,
							   0.2f * Camera.Look_Vector.x, 0.2f * Camera.Look_Vector.y, 0.2f * Camera.Look_Vector.z,
							   0.1f, COLOR(130, 140, 200, 255), 1000, 10.0f);
		}
	}


	//Toggle mouse camera
	if(KEY_DOWN(0x4D))
	{
		mouse_toggle = !mouse_toggle;
		while(KEY_DOWN(0x4D));
	}

	//Yaw Left
	if(KEY_DOWN(VK_LEFT))
	{
		Camera.Rotate(CAMERA_YAW, speed);
	}

	//Yaw Right
	if(KEY_DOWN(VK_RIGHT))
	{
		Camera.Rotate(CAMERA_YAW, -speed);
	}

	//Pitch Down
	if(KEY_DOWN(VK_UP))
	{
		Camera.Rotate(CAMERA_PITCH, speed);
	}

	//Pitch Up
	if(KEY_DOWN(VK_DOWN))
	{
		Camera.Rotate(CAMERA_PITCH, -speed);
	}

	//Roll Left (Q)
	if(KEY_DOWN(0x51))
	{
//		Camera.Rotate(CAMERA_ROLL, -speed);
	}

	//Roll Right (E)
	if(KEY_DOWN(0x45))
	{
//		Camera.Rotate(CAMERA_ROLL, speed);
	}

	//Forward (W)
	if(KEY_DOWN(0x57))
	{
		Camera.Move(CAMERA_FORWARD, speed);
	}

	//Back (S)
	if(KEY_DOWN(0x53))
	{
		Camera.Move(CAMERA_FORWARD, -speed);
	}

	//Strafe Left
	if(KEY_DOWN(0x41))
	{
		Camera.Move(CAMERA_RIGHT, speed);
	}

	//Strafe Right
	if(KEY_DOWN(0x44))
	{
		Camera.Move(CAMERA_RIGHT, -speed);
	}

	//Up
	if(KEY_DOWN(VK_LSHIFT))
	{
		Camera.Move(CAMERA_UP, speed);
	}

	//Down
	if(KEY_DOWN(VK_LCONTROL))
	{
		Camera.Move(CAMERA_UP, -speed);
	}

	if(KEY_DOWN(VK_SPACE))
	{
		Sparky.AddParticle(1, Camera.Position.x, Camera.Position.y, Camera.Position.z,
				   0.2f * Camera.Look_Vector.x, 0.2f * Camera.Look_Vector.y, 0.2f * Camera.Look_Vector.z,
				   0.1f, COLOR(130, 140, 200, 255), 1000, 10.0f);
	}


	mouse_last_x = mouse.x;
	mouse_last_y = mouse.y;
}

void GUI::LoadTexture(char *file, int id)
{
	int i = 0, j = 0, index = 0;
	AUX_RGBImageRec *data = NULL;

	data = auxDIBImageLoad(file);
	if(data == NULL)
	{
		fl_message("Error loading image file: %s. (Line: %d)", file, __LINE__);
		return;
	}
	
	glBindTexture(GL_TEXTURE_2D, id);
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glTexImage2D(GL_TEXTURE_2D, 0, 3, data->sizeX, data->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, data->data);

	if(data != NULL)
	{
		delete[] data;
		data = NULL;
	}
}

void GUI::LoadCylinder(char *file, GL_Material *material)
{
	if(file)
	{
		Cylinder *tmp = new Cylinder(file, 90, 40, VECTOR3(0, 0, 0), material, &Timer);
		world_objects.push_back(tmp);
	}
}

