/* Program: TYAC.H
 *          (Teach Yourself Advanced C)
 * Authors: Bradle y L. Jones
 *          Gregory L. Guntle
 * Purpose: Header file for TYAC library functions
 *=======================================================*/

#ifndef _TYAC_H_
#define _TYAC_H_

#include <stdio.h>  /* for def of FILE */

/* DOS and BIOS Interrupts */
#define BIOS_VIDEO       0x10
#define BIOS_KEY         0x16
#define DOS_FUNCTION     0x21

/* BIOS function calls */
#define SET_VIDEO        0x00
#define SET_CURSOR_SIZE  0x01
#define SET_CURSOR_POS   0x02
#define GET_CURSOR_INFO  0x03
#define READ_CHAR_ATTR   0x08
#define WRITE_CHAR       0x09
#define SET_COLOR        0x0B
#define GET_VIDEO        0x0F
#define WRITE_STRING     0x13

/* BIOS used to set scrolling direction */
#define SCROLL_UP        0x07
#define SCROLL_DOWN      0x06

/* DOS functions calls */
#define GET_DATE         0x2A


/*  Types of Boxes  */
#define DOUBLE_BOX       1
#define SINGLE_BOX       2
#define BLANK_BOX        3

/*  Box fill flags  */
#define BORDER_ONLY      0
#define FILL_BOX         1

/* Menu shadow options */
#define SHADOW           1
#define NO_SHADOW        0

/* Colors */
#define BLACK            0
#define BLUE             1
#define GREEN            2
#define CYAN             3
#define RED              4
#define MAGENTA          5
#define BROWN            6
#define WHITE            7
#define GRAY             8
#define LIGHTBLUE        9
#define LIGHTGREEN       10
#define LIGHTCYAN        11
#define LIGHTRED         12
#define LIGHTMAGENTA     13
#define YELLOW           14
#define BRIGHTWHITE      15

#define BLANK            ' '
#define SPACE            ' '
#define NEWLINE          '\n'
#define TAB              '\t'
#ifndef NULL
   #define NULL          '\0'
#endif

#define EOS              0
#define YES              1
#define NO               0
#define TRUE             1
#define FALSE            0

#define CR               13
#define LF               10
#define EOL              13

#define CLR_INS          1         /* Clear Inside Box Flag */
#define NO_CLR           0         /* Don't Clear Inside the Box */

#define CTR_STR          1         /* Centering a string on the screen */
#define NO_CTR_STR       0         /* Don't center the string */

#define SCREEN_ROW       80*2      /* 80 cols 2 chars (ch + attribute) */

/* -------------------------------- *
 *     FILE I/O Errors/Flags        *
 * -------------------------------- */

#define NO_ERROR         00
#define OPEN_ERROR       01
#define CREATE_ERROR     02
#define USER_CREATE_ERR  03
#define SEEK_ERROR       04
#define WRITE_ERROR      05
#define READ_ERROR       06
#define CLOSE_ERROR      07
#define NOT_FOUND        08

#define PREVIOUS_REC     01
#define NEXT_REC         00

/* -------------------------------- *
 *   Numeric Conversion Flags       *
 * -------------------------------- */

#define PACK_ZERO        01    /* For packing numerials */
#define NO_PACK          00    /* w/ zeros at the front */

/* -------------------------------- *
 *       New Type Definitions       *
 * -------------------------------- */

typedef int BOOLEAN;
typedef unsigned short PTR;        /*               0 -         65535 */
typedef char CHAR;                 /*            -128 -           127 */
typedef unsigned char EXTCHAR;     /*               0 -           255 */
typedef short NUM32K;              /*          -32768 -         32767 */
typedef unsigned short NUM64K;     /*               0 -         65535 */
typedef long NUM2GIGA;             /*  -2,147,483,648 - 2,147,483,647 */
typedef unsigned long NUM4GIGA;    /*               0 - 4,294,967,295 */
typedef unsigned char ARRAY;         /* Used for creating an array */


/* ------------------------------ *
 *           KEYS                 *
 * ------------------------------ */

/* Numeric keypad scan codes    */
#define  HOME       71        /*   home key   */
#define  UP_ARROW   72        /*   up arrow    */
#define  PAGE_UP    73        /*   page up     */
#define  LT_ARROW   75        /*   left arrow  */
#define  RT_ARROW   77        /*   right arrow */
#define  END        79        /*   end key     */
#define  DN_ARROW   80        /*   down arrow  */
#define  PAGE_DN    81        /*   page down   */
#define  INS        82        /*   insert      */
#define  DEL        83        /*   delete      */
#define  SHIFT_TAB  15        /*   shift tab   */
#define  ENTER_KEY  13        /*28*/

/* Function key scan codes */
#define  F1         59        /*     F1 KEY   */
#define  F2         60        /*     F2 KEY   */
#define  F3         61        /*     F3 KEY   */
#define  F4         62        /*     F4 KEY   */
#define  F5         63        /*     F5 KEY   */
#define  F6         64        /*     F6 KEY   */
#define  F7         65        /*     F7 KEY   */
#define  F8         66        /*     F8 KEY   */
#define  F9         67        /*     F9 KEY   */
#define  F10        68        /*     F10 KEY  */

/*  Other non scan keys as ASCII  */

#define  BK_SP_KEY  8
#define  ESC_KEY    27
#define  CR_KEY     13
#define  TAB_KEY    9
#define  SPACE_BAR  32

/* ------------------------------------- *
 *          Getline Options              *
 * ------------------------------------- */
#define SET_DEFAULTS  0
#define SET_NORMAL    1
#define SET_UNDERLINE 2
#define SET_INS       3
#define GET_ALPHA     6
#define GET_NUM       7
#define CLEAR_FIELD   8
#define SET_EXIT_KEYS 9

/* ------------------------------------- *
 *          Menu Items                   *
 * ------------------------------------- */
#define NOBOX             0
#define MAX_MENU_NBR     10
#define MAX_MENU_LEN     30
#define MAX_KEYS         17
#define NO_LR_ARROW       0   /* Whether to allow Left/Right to exit menu */
#define LR_ARROW          1

/*------------------------*
	 Function Prototypes
 *------------------------*/
	  /* Gets the current date */
void current_date(int *, int *, int *);

	  /* Positions the cursor to row/col */
void cursor(int, int);
	  /* Returns info about cursor */
void get_cursor(int *, int *, int *, int *, int *);
	  /* Sets the size of the cursor */
void set_cursor_size(int, int);

	  /* Hide/show cursor */
void cursor_off(void);
void cursor_on(void);

	  /* clear the keyboard buffer */
void kbclear( void );
	  /* determine keyboard hit */
int  get_key( void );

	  /* scroll the screen */
void scroll( int row,   int col,
				 int width, int hieght,
				 int nbr,   int direction);

	  /* pause until ENTER pressed */
void pause(char *);

	  /* Video mode functions */
void set_video(int);
void get_video(int *, int *, int *);

	  /* Text Graphics functions */
void write_char(char, int, int);
void repeat_char(char, int, int, int);
void write_string(char *, int, int, int, int);
void box(int, int, int, int, int, int, int, int);
void set_border_color(int);
char getline(int, char, int, int, int, int, char * );

	  /* misc functions */
void boop( void );
void waitsec( double );
long get_timer_ticks( void );
void help(void);
void file(void);
	  /*clear screen */
void clear_screen(int, int);

	  /* grid */
void grid(int, int, int, int, int, int, int);
char *save_screen_area(int, int, int, int);
void restore_screen_area( char * );

	  /* display date */
void display_date( int, int, int, int, int, int, int, char );

int  display_menu(int,   int, int, char **, int, char*,
						int *, int, int );

void convert_str(char *, int, int );

	  /* FILE IO */
int open_files(char *, char *);
int close_files(void);
int update_header(void);

int get_rec(int, FILE *, int, int, char * );
int put_rec(int, FILE *, int, int, char * );

#endif

